/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.override;

import io.grpc.Context;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.spi.context.storage.AccessMode;
import io.vertx.grpc.contextstorage.ContextStorageService;
import io.vertx.grpc.contextstorage.GrpcStorage;
import java.util.function.Supplier;

public class ContextStorageOverride
extends Context.Storage {
    private static final ThreadLocal<Context> fallback = new ThreadLocal();
    private static final AccessMode SAME_THREAD = new AccessMode(){

        public Object get(Object[] locals, int idx) {
            return locals[idx];
        }

        public void put(Object[] locals, int idx, Object value) {
            locals[idx] = value;
        }

        public Object getOrCreate(Object[] locals, int idx, Supplier<Object> initialValueSupplier) {
            Object value = locals[idx];
            if (value == null) {
                locals[idx] = value = initialValueSupplier.get();
            }
            return value;
        }
    };

    private static ContextInternal duplicate(ContextInternal context) {
        ContextInternal dup = context.duplicate();
        if (context.isDuplicate()) {
            dup.localContextData().putAll(context.localContextData());
        }
        return dup;
    }

    public Context doAttach(Context toAttach) {
        Context toRestoreLater;
        ContextInternal vertxContext = ContextStorageOverride.vertxContext();
        if (vertxContext != null) {
            ContextInternal next = ContextStorageOverride.duplicate(vertxContext);
            ContextInternal prev = next.beginDispatch();
            next.putLocal(ContextStorageService.CONTEXT_LOCAL, SAME_THREAD, (Object)new GrpcStorage(toAttach, prev));
            GrpcStorage local = (GrpcStorage)next.getLocal(ContextStorageService.CONTEXT_LOCAL, SAME_THREAD);
            toRestoreLater = local != null ? local.currentGrpcContext : null;
        } else {
            toRestoreLater = fallback.get();
            fallback.set(toAttach);
        }
        return toRestoreLater;
    }

    public void detach(Context toDetach, Context toRestore) {
        ContextInternal vertxContext = ContextStorageOverride.vertxContext();
        if (vertxContext != null) {
            GrpcStorage local = (GrpcStorage)vertxContext.getLocal(ContextStorageService.CONTEXT_LOCAL, SAME_THREAD);
            vertxContext.endDispatch(local.prevVertxContext);
        } else if (toRestore == Context.ROOT) {
            fallback.remove();
        } else {
            fallback.set(toRestore);
        }
    }

    public Context current() {
        ContextInternal vertxContext = ContextStorageOverride.vertxContext();
        if (vertxContext != null) {
            GrpcStorage local = (GrpcStorage)vertxContext.getLocal(ContextStorageService.CONTEXT_LOCAL);
            return local != null ? local.currentGrpcContext : null;
        }
        return fallback.get();
    }

    private static ContextInternal vertxContext() {
        return (ContextInternal)Vertx.currentContext();
    }
}

