/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.common.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Compressor;
import io.grpc.Drainable;
import io.grpc.MethodDescriptor;
import io.vertx.core.buffer.Buffer;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.WireFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BridgeMessageEncoder<T>
implements GrpcMessageEncoder<T> {
    private MethodDescriptor.Marshaller<T> marshaller;
    private Compressor compressor;

    public BridgeMessageEncoder(MethodDescriptor.Marshaller<T> marshaller, Compressor compressor) {
        this.marshaller = marshaller;
        this.compressor = compressor;
    }

    public boolean accepts(WireFormat format) {
        return format == WireFormat.PROTOBUF;
    }

    public GrpcMessage encode(T msg, WireFormat format) throws CodecException {
        Buffer encoded;
        switch (format) {
            case PROTOBUF: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (InputStream is = this.marshaller.stream(msg);){
                    OutputStream compressingStream = this.compressor == null ? baos : this.compressor.compress((OutputStream)baos);
                    try (ByteArrayOutputStream o = compressingStream;){
                        if (is instanceof Drainable) {
                            Drainable stream = (Drainable)is;
                            stream.drainTo(compressingStream);
                        } else {
                            int len;
                            byte[] tmp = new byte[1024];
                            while ((len = is.read(tmp)) != -1) {
                                ((OutputStream)o).write(tmp, 0, len);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new CodecException((Throwable)e);
                }
                byte[] bytes = baos.toByteArray();
                encoded = Buffer.buffer((byte[])bytes);
                break;
            }
            case JSON: {
                if (msg instanceof MessageOrBuilder) {
                    MessageOrBuilder mob = (MessageOrBuilder)msg;
                    try {
                        String res = JsonFormat.printer().print(mob);
                        encoded = Buffer.buffer((String)res);
                        break;
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new CodecException((Throwable)e);
                    }
                }
                throw new CodecException();
            }
            default: {
                throw new AssertionError();
            }
        }
        return GrpcMessage.message((String)(this.compressor == null ? "identity" : this.compressor.getMessageEncoding()), (WireFormat)format, (Buffer)encoded);
    }
}

