/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.common.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Decompressor;
import io.grpc.KnownLength;
import io.grpc.MethodDescriptor;
import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.json.DecodeException;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class BridgeMessageDecoder<T>
implements GrpcMessageDecoder<T> {
    private MethodDescriptor.Marshaller<T> marshaller;
    private final MessageLite messageLite;
    private Decompressor decompressor;

    public BridgeMessageDecoder(MethodDescriptor.Marshaller<T> marshaller, Decompressor decompressor) {
        this.messageLite = (MessageLite)((MethodDescriptor.PrototypeMarshaller)marshaller).getMessagePrototype();
        this.marshaller = marshaller;
        this.decompressor = decompressor;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T decode(GrpcMessage msg) {
        switch (msg.format()) {
            case PROTOBUF: {
                try (KnownLengthStream kls = new KnownLengthStream(msg.payload());){
                    if (msg.encoding().equals("identity")) {
                        Object object = this.marshaller.parse((InputStream)((Object)kls));
                        return (T)object;
                    }
                    if (this.decompressor == null) throw new DecodeException();
                    InputStream in = this.decompressor.decompress((InputStream)((Object)kls));
                    Object object = this.marshaller.parse(in);
                    if (in == null) return (T)object;
                    in.close();
                    return (T)object;
                    {
                        catch (Throwable throwable) {
                            try {
                                if (in == null) throw throwable;
                                try {
                                    in.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new CodecException((Throwable)e);
                            }
                        }
                    }
                }
            }
            case JSON: {
                try {
                    Message.Builder builder = (Message.Builder)this.messageLite.toBuilder();
                    JsonFormat.parser().merge(msg.payload().toString(StandardCharsets.UTF_8), builder);
                    return (T)builder.build();
                }
                catch (InvalidProtocolBufferException e) {
                    throw new CodecException((Throwable)e);
                }
            }
        }
        throw new CodecException("Invalid wire format: " + String.valueOf(msg.format()));
    }

    public boolean accepts(WireFormat format) {
        return format == WireFormat.PROTOBUF;
    }

    private static class KnownLengthStream
    extends ByteBufInputStream
    implements KnownLength {
        public KnownLengthStream(Buffer buffer) {
            super(((BufferInternal)buffer).getByteBuf(), buffer.length());
        }

        public void close() {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

