/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.common.impl.stub;

import io.grpc.ClientCall;
import io.grpc.Status;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpcio.common.impl.stub.GrpcWriteStream;
import io.vertx.grpcio.common.impl.stub.StreamObserverReadStream;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ClientCalls {
    private ClientCalls() {
    }

    public static <I, O> Future<O> oneToOne(ContextInternal ctx, I request, ClientCall<I, O> call) {
        PromiseInternal promise = ctx.promise();
        io.grpc.stub.ClientCalls.asyncUnaryCall(call, request, ClientCalls.toStreamObserver(promise, null));
        return promise.future();
    }

    public static <I, O> Future<O> oneToOne(ContextInternal ctx, I request, BiConsumer<I, StreamObserver<O>> delegate) {
        PromiseInternal promise = ctx.promise();
        delegate.accept(request, (StreamObserver<O>)ClientCalls.toStreamObserver(promise, null));
        return promise.future();
    }

    public static <I, O> Future<ReadStream<O>> oneToMany(ContextInternal ctx, I request, BiConsumer<I, StreamObserver<O>> delegate) {
        return ClientCalls.oneToMany(ctx, request, delegate, null, null, null);
    }

    public static <I, O> Future<ReadStream<O>> oneToMany(final ContextInternal ctx, I request, BiConsumer<I, StreamObserver<O>> delegate, final Handler<O> handler, final Handler<Void> endHandler, final Handler<Throwable> exceptionHandler) {
        final Promise promise = Promise.promise();
        delegate.accept(request, (StreamObserver<O>)new ClientResponseObserver<I, O>(){

            public void beforeStart(ClientCallStreamObserver<I> requestStream) {
                StreamObserverReadStream response = new StreamObserverReadStream(ctx, (CallStreamObserver<?>)requestStream);
                response.init();
                response.handler(handler).endHandler(endHandler).exceptionHandler(exceptionHandler);
                promise.succeed(response);
            }

            public void onNext(O value) {
            }

            public void onError(Throwable t) {
            }

            public void onCompleted() {
            }
        });
        return promise.future();
    }

    public static <I, O> Future<O> manyToOne(ContextInternal ctx, Completable<WriteStream<I>> requestHandler, Function<StreamObserver<O>, StreamObserver<I>> delegate) {
        PromiseInternal promise = ctx.promise();
        ClientResponseObserver<I, O> so = ClientCalls.toStreamObserver(promise, blah -> {
            GrpcWriteStream ws = new GrpcWriteStream(ctx, blah);
            requestHandler.succeed(ws);
        });
        delegate.apply((StreamObserver<O>)so);
        return promise.future();
    }

    public static <I, O> Future<ReadStream<O>> manyToMany(ContextInternal ctx, Completable<WriteStream<I>> requestHandler, Function<StreamObserver<O>, StreamObserver<I>> delegate) {
        return ClientCalls.manyToMany(ctx, requestHandler, delegate, null);
    }

    public static <I, O> Future<ReadStream<O>> manyToMany(ContextInternal ctx, Completable<WriteStream<I>> requestHandler, Function<StreamObserver<O>, StreamObserver<I>> delegate, Handler<Throwable> exceptionHandler) {
        return ClientCalls.manyToMany(ctx, requestHandler, delegate, null, null, null);
    }

    public static <I, O> Future<ReadStream<O>> manyToMany(final ContextInternal ctx, Completable<WriteStream<I>> requestHandler, Function<StreamObserver<O>, StreamObserver<I>> delegate, final Handler<O> handler, final Handler<Void> endHandler, final Handler<Throwable> exceptionHandler) {
        PromiseInternal promise = ctx.promise();
        delegate.apply((StreamObserver<O>)new ClientResponseObserver<I, O>((Promise)promise, requestHandler){
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ Completable val$requestHandler;
            {
                this.val$promise = promise;
                this.val$requestHandler = completable;
            }

            public void beforeStart(ClientCallStreamObserver<I> requestStream) {
                StreamObserverReadStream response = new StreamObserverReadStream(ctx, (CallStreamObserver<?>)requestStream);
                response.init();
                response.handler(handler).endHandler(endHandler).exceptionHandler(exceptionHandler);
                this.val$promise.complete(response);
                this.val$requestHandler.complete(new GrpcWriteStream(ctx, requestStream), null);
            }

            public void onNext(O value) {
            }

            public void onError(Throwable t) {
            }

            public void onCompleted() {
            }
        });
        return promise.future();
    }

    private static <I, O> ClientResponseObserver<I, O> toStreamObserver(final Promise<O> promise, final Consumer<ClientCallStreamObserver<I>> callback) {
        return new ClientResponseObserver<I, O>(){

            public void beforeStart(ClientCallStreamObserver<I> requestStream) {
                if (callback != null) {
                    callback.accept(requestStream);
                }
            }

            public void onNext(O tResponse) {
                if (!promise.tryComplete(tResponse)) {
                    throw Status.INTERNAL.withDescription("More than one responses received for unary or client-streaming call").asRuntimeException();
                }
            }

            public void onError(Throwable throwable) {
                promise.tryFail(throwable);
            }

            public void onCompleted() {
            }
        };
    }
}

