/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.stub;

import io.grpc.stub.StreamObserver;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.stub.GrpcWriteStream;
import io.vertx.grpc.stub.StreamObserverReadStream;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class ClientCalls {
    private ClientCalls() {
    }

    public static <I, O> Future<O> oneToOne(I request, BiConsumer<I, StreamObserver<O>> delegate) {
        Promise promise = Promise.promise();
        delegate.accept(request, ClientCalls.toStreamObserver(promise));
        return promise.future();
    }

    public static <I, O> ReadStream<O> oneToMany(I request, BiConsumer<I, StreamObserver<O>> delegate) {
        StreamObserverReadStream response = new StreamObserverReadStream();
        delegate.accept(request, response);
        return response;
    }

    public static <I, O> Future<O> manyToOne(Handler<WriteStream<I>> requestHandler, Function<StreamObserver<O>, StreamObserver<I>> delegate) {
        Promise promise = Promise.promise();
        StreamObserver<I> request = delegate.apply(ClientCalls.toStreamObserver(promise));
        requestHandler.handle(new GrpcWriteStream<I>(request));
        return promise.future();
    }

    public static <I, O> ReadStream<O> manyToMany(Handler<WriteStream<I>> requestHandler, Function<StreamObserver<O>, StreamObserver<I>> delegate) {
        StreamObserverReadStream response = new StreamObserverReadStream();
        StreamObserver<I> request = delegate.apply(response);
        requestHandler.handle(new GrpcWriteStream<I>(request));
        return response;
    }

    private static <O> StreamObserver<O> toStreamObserver(final Promise<O> promise) {
        return new StreamObserver<O>(){

            public void onNext(O tResponse) {
                promise.complete(tResponse);
            }

            public void onError(Throwable throwable) {
                promise.fail(throwable);
            }

            public void onCompleted() {
            }
        };
    }
}

