/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.impl;

import io.grpc.stub.StreamObserver;
import io.vertx.core.Handler;
import io.vertx.grpc.GrpcWriteStream;

public class GrpcWriteStreamImpl<T>
implements GrpcWriteStream<T> {
    private final StreamObserver<T> observer;
    private final Handler<Throwable> errHandler;

    public GrpcWriteStreamImpl(StreamObserver<T> observer) {
        this.observer = observer;
        this.errHandler = arg_0 -> observer.onError(arg_0);
    }

    @Override
    public GrpcWriteStreamImpl<T> exceptionHandler(Handler<Throwable> handler) {
        handler.handle((Object)new RuntimeException("Unsupported Operation"));
        return this;
    }

    @Override
    public GrpcWriteStreamImpl<T> write(T t) {
        this.observer.onNext(t);
        return this;
    }

    public void end() {
        this.observer.onCompleted();
    }

    @Override
    public GrpcWriteStreamImpl<T> setWriteQueueMaxSize(int i) {
        this.errHandler.handle((Object)new RuntimeException("Unsupported Operation"));
        return this;
    }

    public boolean writeQueueFull() {
        return false;
    }

    @Override
    public GrpcWriteStreamImpl<T> drainHandler(Handler<Void> handler) {
        this.errHandler.handle((Object)new RuntimeException("Unsupported Operation"));
        return this;
    }

    @Override
    public GrpcWriteStreamImpl<T> fail(Throwable t) {
        this.observer.onError(t);
        return this;
    }

    @Override
    public StreamObserver<T> writeObserver() {
        return this.observer;
    }
}

