/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.MessageSizeOverflowException;
import io.vertx.grpc.common.impl.GrpcMessageDeframer;

public class TranscodingMessageDeframer
implements GrpcMessageDeframer {
    private long maxMessageSize;
    private boolean processed;
    private Buffer buffer;
    private Object result;

    public void maxMessageSize(long maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public void update(Buffer chunk) {
        if (this.processed) {
            return;
        }
        if (this.buffer == null) {
            this.buffer = chunk;
        } else {
            try {
                this.buffer.appendBuffer(chunk);
            }
            catch (IndexOutOfBoundsException e) {
                this.buffer = this.buffer.copy();
                this.buffer.appendBuffer(chunk);
            }
        }
        if (this.result == null && (long)this.buffer.length() > this.maxMessageSize) {
            this.result = new MessageSizeOverflowException((long)this.buffer.length());
            this.buffer = null;
            this.processed = true;
        }
    }

    public void end() {
        if (!this.processed) {
            this.result = GrpcMessage.message((String)"identity", (Buffer)(this.buffer == null ? Buffer.buffer() : this.buffer));
            this.buffer = null;
        }
    }

    public Object next() {
        if (this.result != null) {
            Object ret = this.result;
            this.result = null;
            return ret;
        }
        return null;
    }
}

