/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.base64.Base64;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.grpc.common.GrpcMediaType;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.GrpcMessageDeframer;
import io.vertx.grpc.common.impl.GrpcMethodCall;
import io.vertx.grpc.common.impl.Http2GrpcMessageDeframer;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.impl.GrpcServerRequestImpl;

public class WebGrpcServerRequest<Req, Resp>
extends GrpcServerRequestImpl<Req, Resp> {
    public WebGrpcServerRequest(ContextInternal context, GrpcProtocol protocol, WireFormat format, long maxMessageSize, HttpServerRequest httpRequest, GrpcMessageDecoder<Req> messageDecoder, GrpcMethodCall methodCall) {
        super(context, protocol, format, httpRequest, httpRequest.version() != HttpVersion.HTTP_2 && GrpcMediaType.isGrpcWebText((CharSequence)httpRequest.getHeader(HttpHeaders.CONTENT_TYPE)) ? new TextMessageDeframer() : new Http2GrpcMessageDeframer(maxMessageSize, httpRequest.headers().get("grpc-encoding"), format), messageDecoder, methodCall);
    }

    static class TextMessageDeframer
    implements GrpcMessageDeframer {
        private boolean ended;
        private boolean processed;
        private Buffer buffer;

        TextMessageDeframer() {
        }

        public void update(Buffer chunk) {
            if (this.buffer == null) {
                this.buffer = chunk;
            } else {
                try {
                    this.buffer.appendBuffer(chunk);
                }
                catch (IndexOutOfBoundsException e) {
                    this.buffer = this.buffer.copy();
                    this.buffer.appendBuffer(chunk);
                }
            }
        }

        public void end() {
            this.ended = true;
        }

        public Object next() {
            if (!this.ended || this.processed) {
                return null;
            }
            this.processed = true;
            if (this.buffer == null) {
                return null;
            }
            BufferInternal decoded = BufferInternal.buffer((ByteBuf)Base64.decode((ByteBuf)((BufferInternal)this.buffer).getByteBuf()));
            GrpcMessage ret = GrpcMessage.message((String)"identity", (Buffer)decoded.slice(5, decoded.length()));
            this.buffer = null;
            return ret;
        }
    }
}

