/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import com.google.protobuf.Descriptors;
import io.vertx.core.Handler;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.GrpcServerRequest;
import io.vertx.grpc.server.Service;
import io.vertx.grpc.server.ServiceBuilder;
import java.util.LinkedList;
import java.util.List;

public class ServiceBuilderImpl
implements ServiceBuilder {
    private final ServiceName serviceName;
    private final Descriptors.ServiceDescriptor descriptor;
    private final List<ServiceMethodBinding<?, ?>> handlers = new LinkedList();

    public ServiceBuilderImpl(ServiceName serviceName, Descriptors.ServiceDescriptor descriptor) {
        this.serviceName = serviceName;
        this.descriptor = descriptor;
    }

    @Override
    public <Req, Resp> ServiceBuilder bind(ServiceMethod<Req, Resp> serviceMethod, Handler<GrpcServerRequest<Req, Resp>> handler) {
        this.handlers.add(new ServiceMethodBinding<Req, Resp>(serviceMethod, handler));
        return this;
    }

    @Override
    public Service build() {
        return new Service(){

            @Override
            public ServiceName name() {
                return ServiceBuilderImpl.this.serviceName;
            }

            @Override
            public Descriptors.ServiceDescriptor descriptor() {
                return ServiceBuilderImpl.this.descriptor;
            }

            @Override
            public void bind(GrpcServer server) {
                ServiceBuilderImpl.this.handlers.forEach(h -> h.bind(server));
            }
        };
    }

    public static final class ServiceMethodBinding<Req, Resp> {
        private final ServiceMethod<Req, Resp> serviceMethod;
        private final Handler<GrpcServerRequest<Req, Resp>> handler;

        public ServiceMethodBinding(ServiceMethod<Req, Resp> serviceMethod, Handler<GrpcServerRequest<Req, Resp>> handler) {
            this.serviceMethod = serviceMethod;
            this.handler = handler;
        }

        private ServiceMethod<Req, Resp> serviceMethod() {
            return this.serviceMethod;
        }

        private Handler<GrpcServerRequest<Req, Resp>> handler() {
            return this.handler;
        }

        public void bind(GrpcServer server) {
            server.callHandler(this.serviceMethod, this.handler);
        }
    }
}

