/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server;

import io.vertx.core.http.HttpVersion;
import java.util.EnumSet;

public enum GrpcProtocol {
    HTTP_2("application/grpc", EnumSet.of(HttpVersion.HTTP_2)),
    TRANSCODING("application/json", EnumSet.allOf(HttpVersion.class)),
    WEB("application/grpc-web", EnumSet.allOf(HttpVersion.class)),
    WEB_TEXT("application/grpc-web-text", EnumSet.allOf(HttpVersion.class));

    private final String mediaType;
    private final EnumSet<HttpVersion> acceptedVersions;

    private GrpcProtocol(String mediaType, EnumSet<HttpVersion> acceptedVersions) {
        this.mediaType = mediaType;
        this.acceptedVersions = acceptedVersions;
    }

    public boolean accepts(HttpVersion version) {
        return this.acceptedVersions.contains(version);
    }

    public String mediaType() {
        return this.mediaType;
    }
}

