/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.http.HttpServerRequestInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.spi.context.storage.AccessMode;
import io.vertx.grpc.common.GrpcLocal;
import io.vertx.grpc.common.GrpcMediaType;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.MessageSizeOverflowException;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.GrpcMethodCall;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.GrpcServerOptions;
import io.vertx.grpc.server.GrpcServerRequest;
import io.vertx.grpc.server.impl.GrpcServerRequestImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrpcServerImpl
implements GrpcServer {
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("application/grpc(-web(-text)?)?(\\+(json|proto))?");
    private static final Logger log = LoggerFactory.getLogger(GrpcServer.class);
    private final GrpcServerOptions options;
    private Handler<GrpcServerRequest<Buffer, Buffer>> requestHandler;
    private final Map<String, List<MethodCallHandler<?, ?>>> methodCallHandlers = new HashMap();

    public GrpcServerImpl(Vertx vertx, GrpcServerOptions options) {
        this.options = new GrpcServerOptions(Objects.requireNonNull(options, "options is null"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handle(HttpServerRequest httpRequest) {
        Handler<GrpcServerRequest<Buffer, Buffer>> handler;
        WireFormat format;
        int errorCode = this.refuseRequest(httpRequest);
        if (errorCode > 0) {
            httpRequest.response().setStatusCode(errorCode).end();
            return;
        }
        String contentType = httpRequest.getHeader(HttpHeaders.CONTENT_TYPE);
        if (contentType == null) {
            httpRequest.response().setStatusCode(415).end();
            return;
        }
        Matcher matcher = CONTENT_TYPE_PATTERN.matcher(contentType);
        if (!matcher.matches()) {
            httpRequest.response().setStatusCode(415).end();
            return;
        }
        GrpcProtocol protocol = matcher.group(1) != null ? (matcher.group(2) == null ? GrpcProtocol.WEB : GrpcProtocol.WEB_TEXT) : GrpcProtocol.HTTP_2;
        if (protocol.isWeb() && !this.options.isGrpcWebEnabled()) {
            httpRequest.response().setStatusCode(415).end();
            return;
        }
        if (matcher.group(3) != null) {
            switch (matcher.group(4)) {
                case "proto": {
                    format = WireFormat.PROTOBUF;
                    break;
                }
                case "json": {
                    format = WireFormat.JSON;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not possible");
                }
            }
        } else {
            format = WireFormat.PROTOBUF;
        }
        GrpcMethodCall methodCall = new GrpcMethodCall(httpRequest.path());
        String fmn = methodCall.fullMethodName();
        List<MethodCallHandler<?, ?>> methods = this.methodCallHandlers.get(fmn);
        if (methods != null) {
            for (MethodCallHandler<?, ?> method : methods) {
                if (method.messageEncoder.format() != format || method.messageDecoder.format() != format) continue;
                this.handle(method, httpRequest, methodCall, protocol, format);
                return;
            }
        }
        if ((handler = this.requestHandler) != null) {
            this.handle(httpRequest, methodCall, protocol, format, GrpcMessageDecoder.IDENTITY, GrpcMessageEncoder.IDENTITY, handler);
            return;
        }
        httpRequest.response().setStatusCode(500).end();
    }

    private int refuseRequest(HttpServerRequest request) {
        if (request.version() != HttpVersion.HTTP_2) {
            if (!this.options.isGrpcWebEnabled()) {
                log.trace((Object)"gRPC-Web is not enabled, sending error 505");
                return 505;
            }
            if (!GrpcMediaType.isGrpcWeb((CharSequence)request.headers().get(HttpHeaders.CONTENT_TYPE))) {
                log.trace((Object)"gRPC-Web is the only media type supported on HTTP/1.1, sending error 415");
                return 415;
            }
        }
        return -1;
    }

    private <Req, Resp> void handle(MethodCallHandler<Req, Resp> method, HttpServerRequest httpRequest, GrpcMethodCall methodCall, GrpcProtocol protocol, WireFormat format) {
        this.handle(httpRequest, methodCall, protocol, format, method.messageDecoder, method.messageEncoder, method);
    }

    private <Req, Resp> void handle(HttpServerRequest httpRequest, GrpcMethodCall methodCall, GrpcProtocol protocol, WireFormat format, GrpcMessageDecoder<Req> messageDecoder, GrpcMessageEncoder<Resp> messageEncoder, Handler<GrpcServerRequest<Req, Resp>> handler) {
        ContextInternal context = ((HttpServerRequestInternal)httpRequest).context();
        GrpcServerRequestImpl grpcRequest = new GrpcServerRequestImpl(context, this.options.getScheduleDeadlineAutomatically(), protocol, format, this.options.getMaxMessageSize(), httpRequest, messageDecoder, messageEncoder, methodCall);
        if (this.options.getDeadlinePropagation() && grpcRequest.timeout() > 0L) {
            long deadline = System.currentTimeMillis() + grpcRequest.timeout;
            context.putLocal(GrpcLocal.CONTEXT_LOCAL_KEY, AccessMode.CONCURRENT, (Object)new GrpcLocal(deadline));
        }
        grpcRequest.init(grpcRequest.response);
        grpcRequest.invalidMessageHandler(invalidMsg -> {
            if (invalidMsg instanceof MessageSizeOverflowException) {
                grpcRequest.response().status(GrpcStatus.RESOURCE_EXHAUSTED).end();
            } else {
                grpcRequest.response.cancel();
            }
        });
        context.dispatch(grpcRequest, handler);
    }

    @Override
    public GrpcServer callHandler(Handler<GrpcServerRequest<Buffer, Buffer>> handler) {
        this.requestHandler = handler;
        return this;
    }

    @Override
    public <Req, Resp> GrpcServer callHandler(ServiceMethod<Req, Resp> serviceMethod, Handler<GrpcServerRequest<Req, Resp>> handler) {
        if (handler != null) {
            MethodCallHandler p = new MethodCallHandler(serviceMethod.decoder(), serviceMethod.encoder(), handler);
            this.methodCallHandlers.compute(serviceMethod.fullMethodName(), (key, prev) -> {
                if (prev == null) {
                    prev = new ArrayList<MethodCallHandler>();
                }
                for (int i = 0; i < prev.size(); ++i) {
                    MethodCallHandler a = (MethodCallHandler)prev.get(i);
                    if (a.messageDecoder.format() != serviceMethod.decoder().format() || a.messageEncoder.format() != serviceMethod.encoder().format()) continue;
                    prev.set(i, p);
                    return prev;
                }
                prev.add(p);
                return prev;
            });
        } else {
            this.methodCallHandlers.compute(serviceMethod.fullMethodName(), (key, prev) -> {
                if (prev != null) {
                    for (int i = 0; i < prev.size(); ++i) {
                        MethodCallHandler a = (MethodCallHandler)prev.get(i);
                        if (a.messageDecoder.format() != serviceMethod.decoder().format() || a.messageEncoder.format() != serviceMethod.encoder().format()) continue;
                        prev.remove(i);
                        break;
                    }
                    if (prev.isEmpty()) {
                        prev = null;
                    }
                }
                return prev;
            });
        }
        return this;
    }

    private static class MethodCallHandler<Req, Resp>
    implements Handler<GrpcServerRequest<Req, Resp>> {
        final GrpcMessageDecoder<Req> messageDecoder;
        final GrpcMessageEncoder<Resp> messageEncoder;
        final Handler<GrpcServerRequest<Req, Resp>> handler;

        MethodCallHandler(GrpcMessageDecoder<Req> messageDecoder, GrpcMessageEncoder<Resp> messageEncoder, Handler<GrpcServerRequest<Req, Resp>> handler) {
            this.messageDecoder = messageDecoder;
            this.messageEncoder = messageEncoder;
            this.handler = handler;
        }

        public void handle(GrpcServerRequest<Req, Resp> grpcRequest) {
            this.handler.handle(grpcRequest);
        }
    }
}

