/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor.type;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.processor.Helper;
import io.vertx.codegen.processor.MapperKind;
import io.vertx.codegen.processor.ModuleInfo;
import io.vertx.codegen.processor.TypeParamInfo;
import io.vertx.codegen.processor.type.ApiTypeInfo;
import io.vertx.codegen.processor.type.ClassKind;
import io.vertx.codegen.processor.type.ClassTypeInfo;
import io.vertx.codegen.processor.type.DataObjectInfo;
import io.vertx.codegen.processor.type.EnumTypeInfo;
import io.vertx.codegen.processor.type.MapperInfo;
import io.vertx.codegen.processor.type.ParameterizedTypeInfo;
import io.vertx.codegen.processor.type.PrimitiveTypeInfo;
import io.vertx.codegen.processor.type.TypeInfo;
import io.vertx.codegen.processor.type.TypeVariableInfo;
import io.vertx.codegen.processor.type.VoidTypeInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TypeReflectionFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeInfo create(Type type) {
        if (type == Void.TYPE) {
            return VoidTypeInfo.INSTANCE;
        }
        if (type instanceof Class) {
            boolean permitted;
            DataObjectInfo dataObject;
            String fqcn = type.getTypeName();
            Class classType = (Class)type;
            if (classType.isPrimitive()) {
                return PrimitiveTypeInfo.PRIMITIVES.get(classType.getName());
            }
            Package pkg = classType.getPackage();
            ModuleInfo module = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classType.getClassLoader());
            try {
                while (pkg != null) {
                    ModuleGen annotation = pkg.getAnnotation(ModuleGen.class);
                    if (annotation != null) {
                        module = new ModuleInfo(pkg.getName(), annotation.name(), annotation.groupPackage());
                        break;
                    }
                    int pos = pkg.getName().lastIndexOf(46);
                    if (pos == -1) {
                        break;
                    }
                    pkg = Package.getPackage(pkg.getName().substring(0, pos));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
            if (classType.isEnum()) {
                return new EnumTypeInfo(fqcn, classType.getDeclaredAnnotation(VertxGen.class) != null, Stream.of(classType.getEnumConstants()).map(Object::toString).collect(Collectors.toList()), module, false, null);
            }
            ClassKind kind = ClassKind.getKind(fqcn, classType.getAnnotation(VertxGen.class) != null);
            ArrayList<TypeParamInfo.Class> typeParams = new ArrayList<TypeParamInfo.Class>();
            int index = 0;
            for (TypeVariable var : classType.getTypeParameters()) {
                typeParams.add(new TypeParamInfo.Class(classType.getName(), index++, var.getName()));
            }
            if (kind == ClassKind.API) {
                Class<?> handlerClass;
                try {
                    handlerClass = classType.getClassLoader().loadClass("io.vertx.core.Handler");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                TypeVariable<Class<?>> classTypeVariable = handlerClass.getTypeParameters()[0];
                Type handlerArg = Helper.resolveTypeParameter(type, classTypeVariable);
                return new ApiTypeInfo(fqcn, true, typeParams, handlerArg != null ? TypeReflectionFactory.create(handlerArg) : null, module, false, false, null);
            }
            if (classType.getDeclaredAnnotation(DataObject.class) != null) {
                MapperInfo serializer = TypeReflectionFactory.getDataObjectSerializer(classType);
                MapperInfo deserializer = TypeReflectionFactory.getDataObjectDeserializer(classType);
                dataObject = new DataObjectInfo(true, serializer, deserializer);
                permitted = false;
            } else {
                dataObject = null;
                permitted = classType.getDeclaredAnnotation(GenIgnore.class) != null;
            }
            return new ClassTypeInfo(kind, fqcn, module, false, typeParams, permitted, dataObject);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            List<TypeInfo> args = Arrays.asList(parameterizedType.getActualTypeArguments()).stream().map(TypeReflectionFactory::create).collect(Collectors.toList());
            Type raw = parameterizedType.getRawType();
            return new ParameterizedTypeInfo((ClassTypeInfo)TypeReflectionFactory.create(raw), false, args);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            TypeParamInfo param = TypeParamInfo.create(typeVar);
            return new TypeVariableInfo(param, false, ((TypeVariable)type).getName());
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    private static MapperInfo getDataObjectSerializer(Class<?> type) {
        try {
            Method m3 = type.getMethod("toJson", new Class[0]);
            if (Modifier.isPublic(m3.getModifiers()) && m3.getReturnType().getName().equals("io.vertx.core.json.JsonObject")) {
                MapperInfo serializer = new MapperInfo();
                serializer.setQualifiedName(type.getName());
                serializer.setKind(MapperKind.SELF);
                return serializer;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static MapperInfo getDataObjectDeserializer(Class<?> type) {
        if (!Modifier.isAbstract(type.getModifiers()) && !type.isInterface()) {
            for (Constructor<?> ct : type.getConstructors()) {
                if (ct.getParameterTypes().length != 1 || !ct.getParameterTypes()[0].getName().equals("io.vertx.core.json.JsonObject") || !Modifier.isPublic(ct.getModifiers())) continue;
                MapperInfo deserializer = new MapperInfo();
                deserializer.setQualifiedName(type.getName());
                deserializer.setKind(MapperKind.SELF);
                return deserializer;
            }
        }
        return null;
    }
}

