/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor;

import io.vertx.codegen.processor.type.ClassKind;
import java.util.HashMap;
import java.util.Map;

public enum PropertyKind {
    VALUE,
    LIST,
    SET,
    MAP;


    public boolean isList() {
        return this == LIST;
    }

    public boolean isSet() {
        return this == SET;
    }

    public boolean isMap() {
        return this == MAP;
    }

    public boolean isValue() {
        return this == VALUE;
    }

    public static Map<String, PropertyKind> vars() {
        HashMap<String, PropertyKind> vars = new HashMap<String, PropertyKind>();
        for (PropertyKind propKind : PropertyKind.values()) {
            vars.put("PROP_" + propKind.name(), propKind);
        }
        return vars;
    }

    static PropertyKind forType(ClassKind kind) {
        switch (kind) {
            case LIST: {
                return LIST;
            }
            case SET: {
                return SET;
            }
            case MAP: {
                return MAP;
            }
        }
        return VALUE;
    }
}

