/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor;

import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.processor.ClassModel;
import io.vertx.codegen.processor.DataObjectModel;
import io.vertx.codegen.processor.EnumModel;
import io.vertx.codegen.processor.GenException;
import io.vertx.codegen.processor.Helper;
import io.vertx.codegen.processor.MapperKind;
import io.vertx.codegen.processor.Model;
import io.vertx.codegen.processor.ModelProvider;
import io.vertx.codegen.processor.ModuleInfo;
import io.vertx.codegen.processor.ModuleModel;
import io.vertx.codegen.processor.PackageModel;
import io.vertx.codegen.processor.type.ClassKind;
import io.vertx.codegen.processor.type.MapperInfo;
import io.vertx.codegen.processor.type.TypeMirrorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class CodeGen {
    private static final List<ModelProvider> PROVIDERS;
    static final Map<ProcessingEnvironment, ClassLoader> loaderMap;
    private final Map<String, Map<String, Map.Entry<TypeElement, Model>>> models = new HashMap<String, Map<String, Map.Entry<TypeElement, Model>>>();
    private final Set<TypeElement> all = new HashSet<TypeElement>();
    private final HashMap<String, PackageElement> modules = new HashMap();
    private final ProcessingEnvironment env;
    private final Elements elementUtils;
    private final Types typeUtils;
    private final TypeMirrorFactory tmf;
    private final List<Converter> converters = new ArrayList<Converter>();

    public CodeGen(ProcessingEnvironment env) {
        this.env = env;
        this.elementUtils = env.getElementUtils();
        this.typeUtils = env.getTypeUtils();
        this.tmf = new TypeMirrorFactory(this.elementUtils, this.typeUtils);
    }

    public void init(RoundEnvironment round, ClassLoader loader) {
        loaderMap.put(this.env, loader);
        Predicate<Element> implFilter = elt -> {
            try {
                return Optional.ofNullable(this.elementUtils.getPackageOf((Element)elt)).map(pkg -> pkg.getQualifiedName().toString()).map(fqn -> !fqn.contains(".impl.") && !fqn.endsWith(".impl")).orElse(true);
            }
            catch (NullPointerException e) {
                return true;
            }
        };
        this.converters.forEach(converter -> {
            TypeElement converterElt;
            TypeElement typeElt;
            TypeMirror type = null;
            if (converter.className != null && (typeElt = this.elementUtils.getTypeElement(converter.className)) != null) {
                type = typeElt.asType();
            }
            if ((converterElt = this.elementUtils.getTypeElement(converter.converter)) == null) {
                throw new RuntimeException("Cannot load " + converter.converter + " converter class");
            }
            TypeMirror converterType = converterElt.asType();
            for (int i = 0; i < converter.selectors.size(); ++i) {
                Resolved next = this.resolveMember(converterElt, converterType, converter.selectors.get(i));
                Element nextElt = next.element;
                Set<Modifier> modifiers = nextElt.getModifiers();
                if (!modifiers.contains((Object)Modifier.PUBLIC)) {
                    throw new GenException(converterElt, "Annotated mapper element must be public");
                }
                if (i == 0 && !modifiers.contains((Object)Modifier.STATIC)) {
                    throw new GenException(converterElt, "Annotated mapper element must be static");
                }
                converterType = next.type;
            }
            if (converterType.getKind() == TypeKind.EXECUTABLE) {
                ExecutableType execType = (ExecutableType)converterType;
                this.processConverter(converterElt, type, converter.selectors, execType);
            }
        });
        round.getRootElements().stream().filter(implFilter).filter(elt -> elt instanceof TypeElement).map(elt -> (TypeElement)elt).forEach(te -> {
            for (ModelProvider provider : PROVIDERS) {
                Model model = provider.getModel(this.env, this.tmf, (TypeElement)te);
                if (model == null) continue;
                String kind = model.getKind();
                this.all.add((TypeElement)te);
                Map map = this.models.computeIfAbsent(kind, a -> new HashMap());
                ModelEntry<TypeElement, Model> entry = new ModelEntry<TypeElement, Model>((TypeElement)te, () -> model);
                map.put(Helper.getNonGenericType(te.asType().toString()), entry);
            }
        });
        round.getElementsAnnotatedWith(ModuleGen.class).stream().map(element -> (PackageElement)element).forEach(element -> this.modules.put(element.getQualifiedName().toString(), (PackageElement)element));
    }

    private Resolved resolveMember(Element elt, TypeMirror type, String member) {
        TypeKind kind = type.getKind();
        if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            return declaredType.asElement().getEnclosedElements().stream().filter(e -> e.getSimpleName().toString().equals(member)).findFirst().map(memberElt -> new Resolved((Element)memberElt, this.typeUtils.asMemberOf(declaredType, (Element)memberElt))).orElseThrow(() -> new GenException(elt, "Cannot find member " + member + " of type " + type));
        }
        throw new GenException(elt, "Only declared element are supported");
    }

    private void processConverter(TypeElement converterElt, TypeMirror dataObjectType, List<String> selectors, ExecutableType methodType) {
        if (methodType.getParameterTypes().size() < 1) {
            throw new GenException(converterElt, "Annotated method mapper cannot have empty arguments");
        }
        if (methodType.getParameterTypes().size() > 1) {
            throw new GenException(converterElt, "Annotated method mapper must have one argument");
        }
        TypeMirror paramType = methodType.getParameterTypes().get(0);
        if (paramType.toString().equals("java.lang.CharSequence")) {
            paramType = this.elementUtils.getTypeElement("java.lang.String").asType();
        }
        TypeMirror returnType = methodType.getReturnType();
        ClassKind paramKind = ClassKind.getKind(paramType.toString(), false);
        ClassKind returnKind = ClassKind.getKind(returnType.toString(), false);
        if (paramKind.json || paramKind.basic || paramKind == ClassKind.OBJECT) {
            MapperInfo mapper = new MapperInfo();
            mapper.setQualifiedName(converterElt.getQualifiedName().toString());
            mapper.setTargetType(this.tmf.create(paramType));
            mapper.setSelectors(selectors);
            mapper.setKind(MapperKind.STATIC_METHOD);
            if (!this.typeUtils.isSubtype(returnType, dataObjectType)) {
                throw new GenException(converterElt, methodType + " return should be the same or extend " + dataObjectType);
            }
            this.tmf.addDataObjectDeserializer(converterElt, dataObjectType, mapper);
        } else if (returnKind.json || returnKind.basic || returnKind == ClassKind.OBJECT) {
            MapperInfo mapper = new MapperInfo();
            mapper.setQualifiedName(converterElt.getQualifiedName().toString());
            mapper.setTargetType(this.tmf.create(returnType));
            mapper.setSelectors(selectors);
            mapper.setKind(MapperKind.STATIC_METHOD);
            if (!this.typeUtils.isSubtype(dataObjectType, paramType)) {
                throw new GenException(converterElt, methodType + " parameter should be the same or be a super type of " + dataObjectType);
            }
            this.tmf.addDataObjectSerializer(converterElt, dataObjectType, mapper);
        } else {
            throw new GenException(converterElt, "Mapper method does not declare a JSON type");
        }
    }

    public void registerConverter(Converter b) {
        this.converters.add(b);
    }

    public void registerConverter(String className, String serializer, String ... selectors) {
        this.converters.add(new Converter(className, serializer, Arrays.asList(selectors)));
    }

    public Stream<Map.Entry<? extends Element, ? extends Model>> getModels() {
        Stream<Object> s2 = Stream.empty();
        for (Map<String, Map.Entry<TypeElement, Model>> m3 : this.models.values()) {
            s2 = Stream.concat(s2, m3.values().stream());
        }
        return Stream.concat(s2, Stream.concat(this.getModuleModels(), this.getPackageModels()));
    }

    private Stream<Map.Entry<PackageElement, PackageModel>> getPackageModels() {
        return this.all.stream().map(this.elementUtils::getPackageOf).distinct().map(element -> new ModelEntry<PackageElement, PackageModel>((PackageElement)element, () -> new PackageModel(element.getQualifiedName().toString(), ModuleInfo.resolve(this.elementUtils, element))));
    }

    private Stream<Map.Entry<PackageElement, ModuleModel>> getModuleModels() {
        return this.modules.entrySet().stream().map(entry -> new ModelEntry<PackageElement, ModuleModel>((PackageElement)entry.getValue(), () -> this.getModuleModel((String)entry.getKey())));
    }

    public ModuleModel getModuleModel(String modulePackage) {
        PackageElement element = this.modules.get(modulePackage);
        return new ModuleModel(this.elementUtils, this.typeUtils, element);
    }

    public PackageModel getPackageModel(String fqn) {
        return this.getPackageModels().filter(pkg -> ((PackageModel)pkg.getValue()).getFqn().equals(fqn)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public Model getModel(String fqcn, String kind) {
        Map<String, Map.Entry<TypeElement, Model>> map = this.models.get(kind);
        if (map == null) {
            throw new IllegalArgumentException("Source for " + fqcn + " not found");
        }
        Map.Entry<TypeElement, Model> entry = map.get(fqcn);
        if (entry == null) {
            throw new IllegalArgumentException("Source for " + fqcn + " not found");
        }
        return entry.getValue();
    }

    public ClassModel getClassModel(String fqcn) {
        return (ClassModel)this.getModel(fqcn, "class");
    }

    public EnumModel getEnumModel(String fqcn) {
        return (EnumModel)this.getModel(fqcn, "enum");
    }

    public DataObjectModel getDataObjectModel(String fqcn) {
        return (DataObjectModel)this.getModel(fqcn, "dataObject");
    }

    static {
        ArrayList<ModelProvider> list = new ArrayList<ModelProvider>();
        list.add(ModelProvider.CLASS);
        list.add(ModelProvider.DATA_OBJECT);
        list.add(ModelProvider.ENUM);
        try {
            ServiceLoader<ModelProvider> loader = ServiceLoader.load(ModelProvider.class, ModelProvider.class.getClassLoader());
            for (ModelProvider aLoader : loader) {
                list.add(aLoader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PROVIDERS = list;
        loaderMap = new WeakHashMap<ProcessingEnvironment, ClassLoader>();
    }

    private static class ModelEntry<E extends Element, M extends Model>
    implements Map.Entry<E, M> {
        private final E key;
        private final Supplier<M> supplier;
        private M value;

        private ModelEntry(E key, Supplier<M> supplier) {
            this.key = key;
            this.supplier = supplier;
        }

        @Override
        public E getKey() {
            return this.key;
        }

        @Override
        public M getValue() {
            if (this.value == null) {
                this.value = (Model)this.supplier.get();
                this.value.process();
            }
            return this.value;
        }

        @Override
        public M setValue(M value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Converter {
        public final String className;
        public final String converter;
        public final List<String> selectors;

        public Converter(String className, String converter, List<String> selectors) {
            this.className = className;
            this.converter = converter;
            this.selectors = selectors;
        }

        public String toString() {
            return this.className + "=" + this.converter + "#" + this.selectors;
        }
    }

    private static class Resolved {
        final Element element;
        final TypeMirror type;

        private Resolved(Element element, TypeMirror type) {
            this.element = element;
            this.type = type;
        }
    }
}

