/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common.impl;

import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcWriteStream;
import io.vertx.grpc.common.WireFormat;

public class WriteStreamAdapter<T> {
    private WireFormat wireFormat;
    private GrpcWriteStream<T> stream;
    private boolean ready;
    private GrpcMessageEncoder<T> encoder;

    protected void handleReady() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(GrpcWriteStream<T> stream, WireFormat wireFormat, GrpcMessageEncoder<T> encoder) {
        WriteStreamAdapter writeStreamAdapter = this;
        synchronized (writeStreamAdapter) {
            this.stream = stream;
            this.wireFormat = wireFormat;
            this.encoder = encoder;
        }
        stream.drainHandler(v -> this.checkReady());
        this.checkReady();
    }

    public final synchronized boolean isReady() {
        return this.ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(T msg) {
        this.stream.writeMessage(this.encoder.encode(msg, this.wireFormat));
        WriteStreamAdapter writeStreamAdapter = this;
        synchronized (writeStreamAdapter) {
            this.ready = !this.stream.writeQueueFull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReady() {
        WriteStreamAdapter writeStreamAdapter = this;
        synchronized (writeStreamAdapter) {
            if (this.ready || this.stream.writeQueueFull()) {
                return;
            }
            this.ready = true;
        }
        this.handleReady();
    }
}

