/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.net;

import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class RFC3986 {
    private RFC3986() {
    }

    public static String decodeURIComponent(String s) {
        return RFC3986.decodeURIComponent(s, true);
    }

    public static String decodeURIComponent(String s, boolean plus) {
        int i;
        Objects.requireNonNull(s);
        int n = i = !plus ? s.indexOf(37) : RFC3986.indexOfPercentOrPlus(s);
        if (i == -1) {
            return s;
        }
        return RFC3986.decodeAndTransformURIComponent(s, i, plus);
    }

    private static int indexOfPercentOrPlus(String s) {
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (c != '%' && c != '+') continue;
            return i;
        }
        return -1;
    }

    private static String decodeAndTransformURIComponent(String s, int i, boolean plus) {
        byte[] buf = s.getBytes(StandardCharsets.UTF_8);
        int pos = i;
        int size = s.length();
        while (i < size) {
            int c = s.charAt(i);
            if (c == 37) {
                if (i == size - 1) {
                    throw new IllegalArgumentException("unterminated escape sequence at end of string: " + s);
                }
                if ((c = (int)s.charAt(++i)) == 37) {
                    buf[pos++] = 37;
                    break;
                }
                if (i >= size - 1) {
                    throw new IllegalArgumentException("partial escape sequence at end of string: " + s);
                }
                c = RFC3986.decodeHexNibble((char)c);
                char c2 = RFC3986.decodeHexNibble(s.charAt(++i));
                if (c == 65535 || c2 == '\uffff') {
                    throw new IllegalArgumentException("invalid escape sequence `%" + s.charAt(i - 1) + s.charAt(i) + "' at index " + (i - 2) + " of: " + s);
                }
                c = (char)(c * 16 + c2);
                buf[pos++] = (byte)c;
            } else {
                buf[pos++] = (byte)(plus && c == 43 ? 32 : c);
            }
            ++i;
        }
        return new String(buf, 0, pos, StandardCharsets.UTF_8);
    }

    private static char decodeHexNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (char)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        return '\uffff';
    }

    public static String removeDotSegments(CharSequence path) {
        Objects.requireNonNull(path);
        StringBuilder obuf = new StringBuilder(path.length());
        int i = 0;
        while (i < path.length()) {
            int pos;
            if (RFC3986.matches(path, i, "./")) {
                i += 2;
                continue;
            }
            if (RFC3986.matches(path, i, "../")) {
                i += 3;
                continue;
            }
            if (RFC3986.matches(path, i, "/./")) {
                i += 2;
                continue;
            }
            if (RFC3986.matches(path, i, "/.", true)) {
                path = "/";
                i = 0;
                continue;
            }
            if (RFC3986.matches(path, i, "/../")) {
                i += 3;
                pos = obuf.lastIndexOf("/");
                obuf.setLength(pos == -1 ? 0 : pos);
                continue;
            }
            if (RFC3986.matches(path, i, "/..", true)) {
                path = "/";
                i = 0;
                pos = obuf.lastIndexOf("/");
                obuf.setLength(pos == -1 ? 0 : pos);
                continue;
            }
            if (RFC3986.matches(path, i, ".", true) || RFC3986.matches(path, i, "..", true)) break;
            if (path.charAt(i) == '/') {
                ++i;
                if (obuf.length() == 0 || obuf.charAt(obuf.length() - 1) != '/') {
                    obuf.append('/');
                }
            }
            if ((pos = RFC3986.indexOfSlash(path, i)) != -1) {
                obuf.append(path, i, pos);
                i = pos;
                continue;
            }
            obuf.append(path, i, path.length());
            break;
        }
        return obuf.toString();
    }

    private static boolean matches(CharSequence path, int start, String what) {
        return RFC3986.matches(path, start, what, false);
    }

    private static boolean matches(CharSequence path, int start, String what, boolean exact) {
        if (exact && path.length() - start != what.length()) {
            return false;
        }
        if (path.length() - start >= what.length()) {
            for (int i = 0; i < what.length(); ++i) {
                if (path.charAt(start + i) == what.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int indexOfSlash(CharSequence str, int start) {
        for (int i = start; i < str.length(); ++i) {
            if (str.charAt(i) != '/') continue;
            return i;
        }
        return -1;
    }

    public static String normalizePath(String pathname) {
        if (pathname.isEmpty()) {
            return "/";
        }
        int indexOfFirstPercent = pathname.indexOf(37);
        if (indexOfFirstPercent == -1 && pathname.indexOf(46) == -1 && pathname.indexOf("//") == -1) {
            if (pathname.charAt(0) == '/') {
                return pathname;
            }
            return "/" + pathname;
        }
        return RFC3986.normalizePathSlow(pathname, indexOfFirstPercent);
    }

    private static String normalizePathSlow(String pathname, int indexOfFirstPercent) {
        StringBuilder ibuf;
        if (pathname.charAt(0) != '/') {
            ibuf = new StringBuilder(pathname.length() + 1);
            ibuf.append('/');
            if (indexOfFirstPercent != -1) {
                ++indexOfFirstPercent;
            }
        } else {
            ibuf = new StringBuilder(pathname.length());
        }
        ibuf.append(pathname);
        if (indexOfFirstPercent != -1) {
            RFC3986.decodeUnreservedChars(ibuf, indexOfFirstPercent);
        }
        return RFC3986.removeDotSegments(ibuf);
    }

    private static void decodeUnreservedChars(StringBuilder path, int start) {
        while (start < path.length()) {
            if (path.charAt(start) == '%') {
                RFC3986.decodeUnreserved(path, start);
            }
            ++start;
        }
    }

    private static void decodeUnreserved(StringBuilder path, int start) {
        if (start + 3 <= path.length()) {
            int unescaped;
            String escapeSequence = path.substring(start + 1, start + 3);
            try {
                unescaped = Integer.parseInt(escapeSequence, 16);
                if (unescaped < 0) {
                    throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
            }
            if (unescaped >= 65 && unescaped <= 90 || unescaped >= 97 && unescaped <= 122 || unescaped >= 48 && unescaped <= 57 || unescaped == 45 || unescaped == 46 || unescaped == 95 || unescaped == 126) {
                path.setCharAt(start, (char)unescaped);
                path.delete(start + 1, start + 3);
            }
        } else {
            throw new IllegalArgumentException("Invalid position for escape character: " + start);
        }
    }
}

