/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Expectation;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.NoStackTraceTimeoutException;
import io.vertx.core.impl.future.Composition;
import io.vertx.core.impl.future.Eventually;
import io.vertx.core.impl.future.Expect;
import io.vertx.core.impl.future.FixedMapping;
import io.vertx.core.impl.future.FixedOtherwise;
import io.vertx.core.impl.future.Mapping;
import io.vertx.core.impl.future.Otherwise;
import io.vertx.core.impl.future.Transformation;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.FutureInternal;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class FutureBase<T>
implements FutureInternal<T> {
    protected final ContextInternal context;

    protected FutureBase() {
        this(null);
    }

    FutureBase(ContextInternal context) {
        this.context = context;
    }

    @Override
    public final ContextInternal context() {
        return this.context;
    }

    protected final void emitResult(T result, Throwable cause, Completable<? super T> listener) {
        if (this.context != null && !this.context.isRunningOnContext()) {
            this.context.execute(() -> {
                ContextInternal prev = this.context.beginDispatch();
                try {
                    listener.complete(result, cause);
                }
                catch (Throwable t) {
                    this.context.reportException(t);
                }
                finally {
                    this.context.endDispatch(prev);
                }
            });
        } else {
            try {
                listener.complete(result, cause);
            }
            catch (Throwable t) {
                if (this.context != null) {
                    this.context.reportException(t);
                }
                throw t;
            }
        }
    }

    @Override
    public <U> Future<U> compose(Function<? super T, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
        Objects.requireNonNull(successMapper, "No null success mapper accepted");
        Objects.requireNonNull(failureMapper, "No null failure mapper accepted");
        Composition<? super T, U> operation = new Composition<T, U>(this.context, successMapper, failureMapper);
        this.addListener(operation);
        return operation;
    }

    @Override
    public <U> Future<U> transform(Function<AsyncResult<T>, Future<U>> mapper) {
        Objects.requireNonNull(mapper, "No null mapper accepted");
        Transformation<T, U> operation = new Transformation<T, U>(this.context, mapper);
        this.addListener(operation);
        return operation;
    }

    @Override
    public <U> Future<T> eventually(Supplier<Future<U>> supplier) {
        Objects.requireNonNull(supplier, "No null supplier accepted");
        Eventually operation = new Eventually(this.context, supplier);
        this.addListener(operation);
        return operation;
    }

    @Override
    public <U> Future<U> map(Function<? super T, U> mapper) {
        Objects.requireNonNull(mapper, "No null mapper accepted");
        Mapping<? super T, U> operation = new Mapping<T, U>(this.context, mapper);
        this.addListener(operation);
        return operation;
    }

    @Override
    public <V> Future<V> map(V value) {
        FixedMapping transformation = new FixedMapping(this.context, value);
        this.addListener(transformation);
        return transformation;
    }

    @Override
    public Future<T> otherwise(Function<Throwable, T> mapper) {
        Objects.requireNonNull(mapper, "No null mapper accepted");
        Otherwise<T> transformation = new Otherwise<T>(this.context, mapper);
        this.addListener(transformation);
        return transformation;
    }

    @Override
    public Future<T> otherwise(T value) {
        FixedOtherwise<T> operation = new FixedOtherwise<T>(this.context, value);
        this.addListener(operation);
        return operation;
    }

    @Override
    public Future<T> expecting(Expectation<? super T> expectation) {
        Expect<? super T> expect = new Expect<T>(this.context, expectation);
        this.addListener(expect);
        return expect;
    }

    @Override
    public Future<T> timeout(long delay, TimeUnit unit) {
        Promise promise;
        GlobalEventExecutor instance;
        if (this.isComplete()) {
            return this;
        }
        if (this.context != null) {
            instance = this.context.nettyEventLoop();
            promise = this.context.promise();
        } else {
            instance = GlobalEventExecutor.INSTANCE;
            promise = Promise.promise();
        }
        ScheduledFuture task = instance.schedule(() -> {
            String msg = "Timeout " + unit.toMillis(delay) + " (ms) fired";
            promise.fail(new NoStackTraceTimeoutException(msg));
        }, delay, unit);
        this.addListener((value, err) -> {
            if (task.cancel(false)) {
                promise.complete(value, err);
            }
        });
        return promise.future();
    }

    public abstract void addListener(Completable<? super T> var1);

    public abstract void removeListener(Completable<? super T> var1);
}

