/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl.headers;

import io.netty.handler.codec.http.HttpHeaders;
import io.vertx.core.MultiMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HeadersAdaptor
implements MultiMap {
    private final boolean mutable;
    private final HttpHeaders headers;

    public HeadersAdaptor(HttpHeaders headers) {
        this(true, headers);
    }

    private HeadersAdaptor(boolean mutable, HttpHeaders headers) {
        this.mutable = mutable;
        this.headers = headers;
    }

    @Override
    public String get(String name) {
        return this.headers.get(name);
    }

    @Override
    public List<String> getAll(String name) {
        return this.headers.getAll(name);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return this.headers.entries();
    }

    @Override
    public boolean contains(String name) {
        return this.headers.contains(name);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public Set<String> names() {
        return this.headers.names();
    }

    @Override
    public HeadersAdaptor add(String name, String value) {
        if (!this.mutable) {
            throw new IllegalStateException("Read only");
        }
        this.headers.add(name, (Object)value);
        return this;
    }

    @Override
    public HeadersAdaptor add(String name, Iterable<String> values) {
        if (!this.mutable) {
            throw new IllegalStateException("Read only");
        }
        this.headers.add(name, values);
        return this;
    }

    @Override
    public HeadersAdaptor addAll(MultiMap headers) {
        for (Map.Entry<String, String> entry : headers.entries()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public HeadersAdaptor addAll(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public HeadersAdaptor set(String name, String value) {
        if (!this.mutable) {
            throw new IllegalStateException("Read only");
        }
        if (value != null) {
            this.headers.set(name, (Object)value);
        } else {
            this.headers.remove(name);
        }
        return this;
    }

    @Override
    public HeadersAdaptor set(String name, Iterable<String> values) {
        if (!this.mutable) {
            throw new IllegalStateException("Read only");
        }
        this.headers.set(name, values);
        return this;
    }

    @Override
    public HeadersAdaptor setAll(MultiMap httpHeaders) {
        this.clear();
        for (Map.Entry entry : httpHeaders) {
            this.add((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    @Override
    public HeadersAdaptor remove(String name) {
        if (!this.mutable) {
            throw new IllegalStateException("Read only");
        }
        this.headers.remove(name);
        return this;
    }

    @Override
    public HeadersAdaptor clear() {
        if (!this.mutable) {
            throw new IllegalStateException("Read only");
        }
        this.headers.clear();
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.headers.iteratorAsString();
    }

    @Override
    public int size() {
        return this.names().size();
    }

    @Override
    public HeadersAdaptor setAll(Map<String, String> headers) {
        this.clear();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public String get(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.headers.getAll(name);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.headers.contains(name);
    }

    @Override
    public boolean contains(String name, String value, boolean caseInsensitive) {
        return this.headers.contains(name, value, caseInsensitive);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean caseInsensitive) {
        return this.headers.contains(name, value, caseInsensitive);
    }

    @Override
    public HeadersAdaptor add(CharSequence name, CharSequence value) {
        if (!this.mutable) {
            throw new IllegalStateException("Read only");
        }
        this.headers.add(name, (Object)value);
        return this;
    }

    @Override
    public HeadersAdaptor add(CharSequence name, Iterable<CharSequence> values) {
        if (!this.mutable) {
            throw new IllegalStateException("Read only");
        }
        this.headers.add(name, values);
        return this;
    }

    @Override
    public HeadersAdaptor set(CharSequence name, CharSequence value) {
        if (!this.mutable) {
            throw new IllegalStateException("Read only");
        }
        if (value != null) {
            this.headers.set(name, (Object)value);
        } else {
            this.headers.remove(name);
        }
        return this;
    }

    @Override
    public HeadersAdaptor set(CharSequence name, Iterable<CharSequence> values) {
        if (!this.mutable) {
            throw new IllegalStateException("Read only");
        }
        this.headers.set(name, values);
        return this;
    }

    @Override
    public HeadersAdaptor remove(CharSequence name) {
        if (!this.mutable) {
            throw new IllegalStateException("Read only");
        }
        this.headers.remove(name);
        return this;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public MultiMap copy(boolean mutable) {
        if (!this.mutable && !mutable) {
            return this;
        }
        return new HeadersAdaptor(mutable, this.headers.copy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this) {
            sb.append(entry).append('\n');
        }
        return sb.toString();
    }
}

