/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.context.storage.AccessMode;
import io.vertx.core.spi.context.storage.ContextLocal;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

@VertxGen
public interface Context {
    public static boolean isOnWorkerThread() {
        Thread t = Thread.currentThread();
        return t instanceof VertxThread && ((VertxThread)((Object)t)).isWorker();
    }

    public static boolean isOnEventLoopThread() {
        Thread t = Thread.currentThread();
        return t instanceof VertxThread && !((VertxThread)((Object)t)).isWorker();
    }

    public static boolean isOnVertxThread() {
        return Thread.currentThread() instanceof VertxThread;
    }

    public void runOnContext(Handler<Void> var1);

    @GenIgnore(value={"permitted-type"})
    public <T> Future<@Nullable T> executeBlocking(Callable<T> var1, boolean var2);

    @GenIgnore(value={"permitted-type"})
    default public <T> Future<@Nullable T> executeBlocking(Callable<T> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler, true);
    }

    public String deploymentID();

    public @Nullable JsonObject config();

    @Deprecated
    default public List<String> processArgs() {
        return Collections.emptyList();
    }

    public boolean isEventLoopContext();

    public boolean isWorkerContext();

    public ThreadingModel threadingModel();

    public <T> T get(Object var1);

    public void put(Object var1, Object var2);

    public boolean remove(Object var1);

    public Vertx owner();

    public int getInstanceCount();

    @Fluent
    public Context exceptionHandler(@Nullable Handler<Throwable> var1);

    @GenIgnore
    public @Nullable Handler<Throwable> exceptionHandler();

    @GenIgnore(value={"permitted-type"})
    default public <T> T getLocal(ContextLocal<T> key) {
        return this.getLocal(key, AccessMode.CONCURRENT);
    }

    @GenIgnore
    default public <T> T getLocal(ContextLocal<T> key, Supplier<? extends T> initialValueSupplier) {
        return this.getLocal(key, AccessMode.CONCURRENT, initialValueSupplier);
    }

    @GenIgnore(value={"permitted-type"})
    default public <T> void putLocal(ContextLocal<T> key, T value) {
        this.putLocal(key, AccessMode.CONCURRENT, value);
    }

    @GenIgnore(value={"permitted-type"})
    default public <T> void removeLocal(ContextLocal<T> key) {
        this.putLocal(key, null);
    }

    @GenIgnore(value={"permitted-type"})
    public <T> T getLocal(ContextLocal<T> var1, AccessMode var2);

    @GenIgnore
    public <T> T getLocal(ContextLocal<T> var1, AccessMode var2, Supplier<? extends T> var3);

    @GenIgnore(value={"permitted-type"})
    public <T> void putLocal(ContextLocal<T> var1, AccessMode var2, T var3);

    @GenIgnore(value={"permitted-type"})
    default public <T> void removeLocal(ContextLocal<T> key, AccessMode accessMode) {
        this.putLocal(key, accessMode, null);
    }
}

