/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.endpoint;

import io.vertx.core.net.endpoint.DefaultInteractionMetric;
import io.vertx.core.net.endpoint.InteractionMetrics;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class DefaultInteractionMetrics
implements InteractionMetrics<DefaultInteractionMetric> {
    private final LongAdder numberOfInflightRequests = new LongAdder();
    private final LongAdder numberOfRequests = new LongAdder();
    private final LongAdder numberOfFailures = new LongAdder();
    private final AtomicLong minResponseTime = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong maxResponseTime = new AtomicLong(0L);

    @Override
    public DefaultInteractionMetric initiateRequest() {
        this.numberOfInflightRequests.increment();
        this.numberOfRequests.increment();
        return new DefaultInteractionMetric();
    }

    @Override
    public void reportFailure(DefaultInteractionMetric metric, Throwable failure) {
        if (metric.failure == null) {
            metric.failure = failure;
            this.numberOfInflightRequests.decrement();
            this.numberOfFailures.increment();
        }
    }

    @Override
    public void reportRequestBegin(DefaultInteractionMetric metric) {
        metric.requestBegin = System.currentTimeMillis();
    }

    @Override
    public void reportRequestEnd(DefaultInteractionMetric metric) {
        metric.requestEnd = System.currentTimeMillis();
    }

    @Override
    public void reportResponseBegin(DefaultInteractionMetric metric) {
        metric.responseBegin = System.currentTimeMillis();
    }

    @Override
    public void reportResponseEnd(DefaultInteractionMetric metric) {
        metric.responseEnd = System.currentTimeMillis();
        if (metric.failure == null) {
            this.reportRequestMetric(metric);
            this.numberOfInflightRequests.decrement();
        }
    }

    private void reportRequestMetric(DefaultInteractionMetric metric) {
        long val;
        long responseTime = metric.responseEnd - metric.requestBegin;
        while (responseTime < (val = this.minResponseTime.get()) && !this.minResponseTime.compareAndSet(val, responseTime)) {
        }
        while (responseTime > (val = this.maxResponseTime.get()) && !this.maxResponseTime.compareAndSet(val, responseTime)) {
        }
    }

    public int numberOfInflightRequests() {
        return this.numberOfInflightRequests.intValue();
    }

    public int numberOfRequests() {
        return this.numberOfRequests.intValue();
    }

    public int numberOfFailures() {
        return this.numberOfFailures.intValue();
    }

    public int minResponseTime() {
        return this.minResponseTime.intValue();
    }

    public int maxResponseTime() {
        return this.maxResponseTime.intValue();
    }
}

