/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystemProps;
import io.vertx.core.file.OpenOptions;
import java.util.List;

@VertxGen
public interface FileSystem {
    public Future<Void> copy(String var1, String var2);

    public Future<Void> copy(String var1, String var2, CopyOptions var3);

    @Fluent
    public FileSystem copyBlocking(String var1, String var2);

    public Future<Void> copyRecursive(String var1, String var2, boolean var3);

    @Fluent
    public FileSystem copyRecursiveBlocking(String var1, String var2, boolean var3);

    public Future<Void> move(String var1, String var2);

    public Future<Void> move(String var1, String var2, CopyOptions var3);

    @Fluent
    public FileSystem moveBlocking(String var1, String var2);

    public Future<Void> truncate(String var1, long var2);

    @Fluent
    public FileSystem truncateBlocking(String var1, long var2);

    public Future<Void> chmod(String var1, String var2);

    @Fluent
    public FileSystem chmodBlocking(String var1, String var2);

    public Future<Void> chmodRecursive(String var1, String var2, String var3);

    @Fluent
    public FileSystem chmodRecursiveBlocking(String var1, String var2, String var3);

    public Future<Void> chown(String var1, @Nullable String var2, @Nullable String var3);

    @Fluent
    public FileSystem chownBlocking(String var1, @Nullable String var2, @Nullable String var3);

    public Future<FileProps> props(String var1);

    public FileProps propsBlocking(String var1);

    public Future<FileProps> lprops(String var1);

    public FileProps lpropsBlocking(String var1);

    public Future<Void> link(String var1, String var2);

    @Fluent
    public FileSystem linkBlocking(String var1, String var2);

    public Future<Void> symlink(String var1, String var2);

    @Fluent
    public FileSystem symlinkBlocking(String var1, String var2);

    public Future<Void> unlink(String var1);

    @Fluent
    public FileSystem unlinkBlocking(String var1);

    public Future<String> readSymlink(String var1);

    public String readSymlinkBlocking(String var1);

    public Future<Void> delete(String var1);

    @Fluent
    public FileSystem deleteBlocking(String var1);

    public Future<Void> deleteRecursive(String var1);

    @Fluent
    public FileSystem deleteRecursiveBlocking(String var1);

    public Future<Void> mkdir(String var1);

    @Fluent
    public FileSystem mkdirBlocking(String var1);

    public Future<Void> mkdir(String var1, String var2);

    @Fluent
    public FileSystem mkdirBlocking(String var1, String var2);

    public Future<Void> mkdirs(String var1);

    @Fluent
    public FileSystem mkdirsBlocking(String var1);

    public Future<Void> mkdirs(String var1, String var2);

    @Fluent
    public FileSystem mkdirsBlocking(String var1, String var2);

    public Future<List<String>> readDir(String var1);

    public List<String> readDirBlocking(String var1);

    public Future<List<String>> readDir(String var1, String var2);

    public List<String> readDirBlocking(String var1, String var2);

    public Future<Buffer> readFile(String var1);

    public Buffer readFileBlocking(String var1);

    public Future<Void> writeFile(String var1, Buffer var2);

    @Fluent
    public FileSystem writeFileBlocking(String var1, Buffer var2);

    public Future<AsyncFile> open(String var1, OpenOptions var2);

    public AsyncFile openBlocking(String var1, OpenOptions var2);

    public Future<Void> createFile(String var1);

    @Fluent
    public FileSystem createFileBlocking(String var1);

    public Future<Void> createFile(String var1, String var2);

    @Fluent
    public FileSystem createFileBlocking(String var1, String var2);

    public Future<Boolean> exists(String var1);

    public boolean existsBlocking(String var1);

    public Future<FileSystemProps> fsProps(String var1);

    public FileSystemProps fsPropsBlocking(String var1);

    public Future<String> createTempDirectory(String var1);

    public String createTempDirectoryBlocking(String var1);

    public Future<String> createTempDirectory(String var1, String var2);

    public String createTempDirectoryBlocking(String var1, String var2);

    public Future<String> createTempDirectory(String var1, String var2, String var3);

    public String createTempDirectoryBlocking(String var1, String var2, String var3);

    public Future<String> createTempFile(String var1, String var2);

    public String createTempFileBlocking(String var1, String var2);

    public Future<String> createTempFile(String var1, String var2, String var3);

    public String createTempFileBlocking(String var1, String var2, String var3);

    public Future<String> createTempFile(String var1, String var2, String var3, String var4);

    public String createTempFileBlocking(String var1, String var2, String var3, String var4);
}

