/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.deployment;

import io.netty.channel.EventLoop;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextBuilderImpl;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.WorkerPool;
import io.vertx.core.internal.deployment.Deployment;
import io.vertx.core.internal.deployment.DeploymentContext;
import io.vertx.core.internal.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public class DefaultDeployment
implements Deployment {
    private final VertxImpl vertx;
    private final DeploymentOptions options;
    private final Logger log;
    private final List<Deployable> deployables;
    private final ThreadingModel threading;
    private final WorkerPool workerPool;
    private final String identifier;
    private final List<Instance> instances = new CopyOnWriteArrayList<Instance>();
    private final ClassLoader tccl;

    public static DefaultDeployment deployment(VertxImpl vertx, Logger log, DeploymentOptions options, Function<Deployable, String> identifierProvider, ClassLoader tccl, Callable<? extends Deployable> supplier) throws Exception {
        int numberOfInstances = options.getInstances();
        Set deployables = Collections.newSetFromMap(new IdentityHashMap());
        for (int i = 0; i < numberOfInstances; ++i) {
            Deployable deployable = supplier.call();
            if (deployable == null) {
                throw new VertxException("Supplied deployable is null", true);
            }
            deployables.add(deployable);
        }
        if (deployables.size() != numberOfInstances) {
            throw new VertxException("Same deployable supplied more than once", true);
        }
        WorkerPool workerPool = null;
        ThreadingModel mode = options.getThreadingModel();
        if (mode == null) {
            mode = ThreadingModel.EVENT_LOOP;
        }
        if (mode != ThreadingModel.VIRTUAL_THREAD) {
            if (options.getWorkerPoolName() != null) {
                workerPool = vertx.createSharedWorkerPool(options.getWorkerPoolName(), options.getWorkerPoolSize(), options.getMaxWorkerExecuteTime(), options.getMaxWorkerExecuteTimeUnit());
            }
        } else if (!vertx.isVirtualThreadAvailable()) {
            throw new VertxException("This Java runtime does not support virtual threads", true);
        }
        ArrayList<Deployable> list = new ArrayList<Deployable>(deployables);
        return new DefaultDeployment(vertx, options, log, list, identifierProvider.apply((Deployable)list.get(0)), mode, workerPool, tccl);
    }

    public DefaultDeployment(VertxImpl vertx, DeploymentOptions options, Logger log, List<Deployable> deployables, String identifier, ThreadingModel threading, WorkerPool workerPool, ClassLoader tccl) {
        this.vertx = vertx;
        this.log = log;
        this.options = options;
        this.workerPool = workerPool;
        this.deployables = deployables;
        this.identifier = identifier;
        this.threading = threading;
        this.tccl = tccl;
    }

    @Override
    public Set<Context> contexts() {
        HashSet<Context> contexts = new HashSet<Context>();
        for (Instance instance : this.instances) {
            contexts.add(instance.context);
        }
        return contexts;
    }

    @Override
    public Set<Deployable> instances() {
        HashSet<Deployable> instances = new HashSet<Deployable>();
        for (Instance instance : this.instances) {
            instances.add(instance.deployable);
        }
        return instances;
    }

    @Override
    public DeploymentOptions options() {
        return new DeploymentOptions(this.options);
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public Future<?> deploy(DeploymentContext deployment) {
        EventLoop workerLoop = null;
        ArrayList futures = new ArrayList();
        for (Deployable verticle : this.deployables) {
            ContextInternal context;
            CloseFuture closeFuture = new CloseFuture(this.log);
            ContextBuilderImpl contextBuilder = ((ContextBuilderImpl)this.vertx.contextBuilder()).withDeploymentContext(deployment).withCloseFuture(closeFuture).withClassLoader(this.tccl);
            switch (this.threading) {
                case WORKER: {
                    if (workerLoop == null) {
                        context = contextBuilder.withThreadingModel(ThreadingModel.WORKER).withWorkerPool(this.workerPool).build();
                        workerLoop = context.nettyEventLoop();
                        break;
                    }
                    context = contextBuilder.withThreadingModel(ThreadingModel.WORKER).withEventLoop(workerLoop).withWorkerPool(this.workerPool).build();
                    break;
                }
                case VIRTUAL_THREAD: {
                    if (workerLoop == null) {
                        context = contextBuilder.withThreadingModel(ThreadingModel.VIRTUAL_THREAD).build();
                        workerLoop = context.nettyEventLoop();
                        break;
                    }
                    context = contextBuilder.withThreadingModel(ThreadingModel.VIRTUAL_THREAD).withEventLoop(workerLoop).build();
                    break;
                }
                default: {
                    context = contextBuilder.withWorkerPool(this.workerPool).build();
                }
            }
            Instance instance = new Instance(verticle, context);
            PromiseInternal<Object> startPromise = context.promise();
            instance.startPromise = startPromise;
            this.instances.add(instance);
            futures.add(startPromise.future().andThen(ar -> {
                if (ar.succeeded()) {
                    instance.startPromise = null;
                }
            }));
            context.runOnContext(v -> {
                Future<?> fut;
                try {
                    fut = verticle.deploy(context);
                }
                catch (Throwable t) {
                    startPromise.tryFail(t);
                    return;
                }
                fut.onComplete(startPromise);
            });
        }
        return Future.join(futures).transform(ar -> {
            if (ar.failed()) {
                return this.undeploy().transform(ar2 -> (Future)ar);
            }
            return Future.succeededFuture();
        });
    }

    @Override
    public Future<?> undeploy() {
        ArrayList undeployFutures = new ArrayList();
        for (Instance instance : this.instances) {
            Promise<Object> startPromise = instance.startPromise;
            if (startPromise != null) {
                if (!startPromise.tryFail(new VertxException("Verticle un-deployed", true))) continue;
                undeployFutures.add(instance.context.closeFuture().future());
                continue;
            }
            ContextInternal context = instance.context;
            Promise p = Promise.promise();
            undeployFutures.add(p.future());
            context.runOnContext(v -> {
                Future<?> fut;
                Promise stopPromise = Promise.promise();
                stopPromise.future().eventually(() -> instance.close().onFailure(err -> this.log.error((Object)"Failed to run close hook", err))).onComplete(p);
                try {
                    fut = instance.deployable.undeploy(context);
                }
                catch (Throwable t) {
                    if (!stopPromise.tryFail(t)) {
                        context.reportException(t);
                    }
                    return;
                }
                fut.onComplete(stopPromise);
            });
        }
        return Future.join(undeployFutures);
    }

    @Override
    public Future<?> cleanup() {
        ArrayList<Future<Void>> futs = new ArrayList<Future<Void>>();
        for (Instance instance : this.instances) {
            futs.add(instance.context.closeFuture().close());
        }
        Future<CompositeFuture> fut = Future.join(futs);
        if (this.workerPool != null) {
            fut = fut.andThen(ar -> this.workerPool.close());
            this.workerPool.close();
        }
        return fut;
    }

    private static class Instance {
        final Deployable deployable;
        final ContextInternal context;
        Promise<Object> startPromise;

        Instance(Deployable deployable, ContextInternal context) {
            this.deployable = deployable;
            this.context = context;
        }

        Future<Void> close() {
            return this.context.close();
        }
    }
}

