/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.http.ClientWebSocket;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebSocketVersion;
import io.vertx.core.http.impl.ClientWebSocketImpl;
import io.vertx.core.http.impl.EndpointKey;
import io.vertx.core.http.impl.HttpChannelConnector;
import io.vertx.core.http.impl.HttpClientBase;
import io.vertx.core.http.impl.WebSocketGroup;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.resource.ResourceManager;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.function.Function;

public class WebSocketClientImpl
extends HttpClientBase
implements WebSocketClient {
    private final WebSocketClientOptions options;
    private final ResourceManager<EndpointKey, WebSocketGroup> webSocketCM;

    public WebSocketClientImpl(VertxInternal vertx, HttpClientOptions options, WebSocketClientOptions wsOptions) {
        super(vertx, options);
        this.options = wsOptions;
        this.webSocketCM = new ResourceManager();
    }

    @Override
    protected void doShutdown(Promise<Void> p) {
        this.webSocketCM.shutdown();
        super.doShutdown(p);
    }

    @Override
    protected void doClose(Promise<Void> p) {
        this.webSocketCM.close();
        super.doClose(p);
    }

    @Override
    public Future<WebSocket> connect(WebSocketConnectOptions options) {
        return this.webSocket(options);
    }

    void webSocket(ContextInternal ctx, WebSocketConnectOptions connectOptions, Promise<WebSocket> promise) {
        int port = this.getPort(connectOptions);
        String host = this.getHost(connectOptions);
        SocketAddress addr = SocketAddress.inetSocketAddress(port, host);
        HostAndPort peer = HostAndPort.create(host, port);
        ProxyOptions proxyOptions = this.computeProxyOptions(connectOptions.getProxyOptions(), addr);
        ClientSSLOptions sslOptions = this.sslOptions(connectOptions);
        EndpointKey key = new EndpointKey(connectOptions.isSsl() != null ? connectOptions.isSsl().booleanValue() : this.options.isSsl(), sslOptions, proxyOptions, addr, peer);
        Function<EndpointKey, WebSocketGroup> provider = key_ -> {
            int maxPoolSize = this.options.getMaxConnections();
            ClientMetrics clientMetrics = this.metrics != null ? this.metrics.createEndpointMetrics(key_.server, maxPoolSize) : null;
            PoolMetrics<?, ?> queueMetrics = this.metrics != null ? this.vertx.metrics().createPoolMetrics("ws", key_.server.toString(), maxPoolSize) : null;
            HttpChannelConnector connector = new HttpChannelConnector(this, this.netClient, sslOptions, key_.proxyOptions, clientMetrics, HttpVersion.HTTP_1_1, key_.ssl, false, key_.authority, key_.server, false, 0L);
            return new WebSocketGroup(null, queueMetrics, this.options, maxPoolSize, connector);
        };
        this.webSocketCM.withResourceAsync(key, provider, (endpoint, created) -> endpoint.requestConnection(ctx, connectOptions, 0L)).onComplete(c -> {
            if (c.succeeded()) {
                WebSocket conn = (WebSocket)c.result();
                promise.complete(conn);
            } else {
                promise.fail(c.cause());
            }
        });
    }

    public Future<WebSocket> webSocket(int port, String host, String requestURI) {
        return this.webSocket(new WebSocketConnectOptions().setURI(requestURI).setHost(host).setPort(port));
    }

    public Future<WebSocket> webSocket(WebSocketConnectOptions options) {
        return this.webSocket(this.vertx.getOrCreateContext(), options);
    }

    static WebSocketConnectOptions webSocketConnectOptionsAbs(String url, MultiMap headers, WebSocketVersion version, List<String> subProtocols) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String scheme = uri.getScheme();
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("Scheme: " + scheme);
        }
        boolean ssl = scheme.length() == 3;
        int port = uri.getPort();
        if (port == -1) {
            port = ssl ? 443 : 80;
        }
        StringBuilder relativeUri = new StringBuilder();
        if (uri.getRawPath() != null) {
            relativeUri.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            relativeUri.append('?').append(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            relativeUri.append('#').append(uri.getRawFragment());
        }
        return new WebSocketConnectOptions().setHost(uri.getHost()).setPort(port).setSsl(ssl).setURI(relativeUri.toString()).setHeaders(headers).setVersion(version).setSubProtocols(subProtocols);
    }

    public Future<WebSocket> webSocketAbs(String url, MultiMap headers, WebSocketVersion version, List<String> subProtocols) {
        return this.webSocket(WebSocketClientImpl.webSocketConnectOptionsAbs(url, headers, version, subProtocols));
    }

    Future<WebSocket> webSocket(ContextInternal ctx, WebSocketConnectOptions connectOptions) {
        PromiseInternal<WebSocket> promise = ctx.promise();
        this.webSocket(ctx, connectOptions, promise);
        return promise.andThen(ar -> {
            if (ar.succeeded()) {
                ((WebSocket)ar.result()).resume();
            }
        });
    }

    @Override
    public ClientWebSocket webSocket() {
        return new ClientWebSocketImpl(this);
    }
}

