/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.http.ClientWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import java.lang.ref.Cleaner;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;

public class CleanableWebSocketClient
implements WebSocketClient,
MetricsProvider,
Closeable {
    public final WebSocketClient delegate;
    private final Cleaner.Cleanable cleanable;
    private final Action action;

    public CleanableWebSocketClient(WebSocketClient delegate, Cleaner cleaner, BiFunction<Long, TimeUnit, Future<Void>> dispose) {
        this.action = new Action(dispose);
        this.delegate = delegate;
        this.cleanable = cleaner.register(this, this.action);
    }

    @Override
    public ClientWebSocket webSocket() {
        return this.delegate.webSocket();
    }

    @Override
    public Future<WebSocket> connect(WebSocketConnectOptions options) {
        return this.delegate.connect(options);
    }

    @Override
    public Future<Boolean> updateSSLOptions(ClientSSLOptions options, boolean force) {
        return this.delegate.updateSSLOptions(options, force);
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        this.action.timeout = timeout;
        this.action.timeUnit = unit;
        this.cleanable.clean();
        return this.action.closeFuture;
    }

    @Override
    public void close(Promise<Void> completion) {
        ((Closeable)((Object)this.delegate)).close(completion);
    }

    @Override
    public Metrics getMetrics() {
        return ((MetricsProvider)((Object)this.delegate)).getMetrics();
    }

    static class Action
    implements Runnable {
        private final BiFunction<Long, TimeUnit, Future<Void>> dispose;
        private long timeout = 30L;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private Future<Void> closeFuture;

        private Action(BiFunction<Long, TimeUnit, Future<Void>> dispose) {
            this.dispose = dispose;
        }

        @Override
        public void run() {
            this.closeFuture = this.dispose.apply(this.timeout, this.timeUnit);
        }
    }
}

