/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import java.util.function.Function;

public interface AsyncResult<T> {
    public T result();

    public Throwable cause();

    public boolean succeeded();

    public boolean failed();

    default public <U> AsyncResult<U> map(final Function<? super T, U> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        return new AsyncResult<U>(){

            @Override
            public U result() {
                if (this.succeeded()) {
                    return mapper.apply(AsyncResult.this.result());
                }
                return null;
            }

            @Override
            public Throwable cause() {
                return AsyncResult.this.cause();
            }

            @Override
            public boolean succeeded() {
                return AsyncResult.this.succeeded();
            }

            @Override
            public boolean failed() {
                return AsyncResult.this.failed();
            }
        };
    }

    default public <V> AsyncResult<V> map(V value) {
        return this.map((V)((Function<Object, Object>)t -> value));
    }

    default public <V> AsyncResult<V> mapEmpty() {
        return this.map((V)null);
    }

    default public AsyncResult<T> otherwise(final Function<Throwable, T> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        return new AsyncResult<T>(){

            @Override
            public T result() {
                if (AsyncResult.this.succeeded()) {
                    return AsyncResult.this.result();
                }
                if (AsyncResult.this.failed()) {
                    return mapper.apply(AsyncResult.this.cause());
                }
                return null;
            }

            @Override
            public Throwable cause() {
                return null;
            }

            @Override
            public boolean succeeded() {
                return AsyncResult.this.succeeded() || AsyncResult.this.failed();
            }

            @Override
            public boolean failed() {
                return false;
            }
        };
    }

    default public AsyncResult<T> otherwise(T value) {
        return this.otherwise((T)((Function<Throwable, Object>)err -> value));
    }

    default public AsyncResult<T> otherwiseEmpty() {
        return this.otherwise((T)((Function<Throwable, Object>)err -> null));
    }
}

