/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsReceivedConsumer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.Http2ServerStream;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import java.util.function.Function;

public class VertxCompressorHttp2ConnectionEncoder
implements Http2FrameWriter,
Http2ConnectionEncoder,
Http2SettingsReceivedConsumer {
    private Http2ConnectionEncoder delegate;
    private final Http2ConnectionEncoder plainEncoder;

    public VertxCompressorHttp2ConnectionEncoder(Http2ConnectionEncoder plainEncoder, CompressionOptions[] compressionOptions) {
        this.delegate = new CompressorHttp2ConnectionEncoder(plainEncoder, compressionOptions);
        this.plainEncoder = plainEncoder;
    }

    private void beforeWritingHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers responseHeaders) {
        String contentEncodingToApply = this.determineContentEncodingToApply(ctx, streamId, responseHeaders);
        if (contentEncodingToApply == null || contentEncodingToApply.equalsIgnoreCase(HttpHeaders.IDENTITY.toString())) {
            if (responseHeaders.contains((Object)HttpHeaders.CONTENT_ENCODING, (Object)HttpHeaders.IDENTITY)) {
                responseHeaders.remove((Object)HttpHeaders.CONTENT_ENCODING);
            }
            this.delegate = this.plainEncoder;
        } else {
            responseHeaders.set((Object)HttpHeaders.CONTENT_ENCODING, (Object)contentEncodingToApply);
        }
    }

    private String determineContentEncodingToApply(ChannelHandlerContext ctx, int streamId, Http2Headers responseHeaders) {
        if (responseHeaders.contains((Object)HttpHeaders.CONTENT_ENCODING)) {
            return null;
        }
        return this.ifType(ctx.handler(), VertxHttp2ConnectionHandler.class, connectionHandler -> this.ifType(connectionHandler.connectFuture().getNow(), Http2ServerConnection.class, connection -> this.ifType(connection.stream(streamId), Http2ServerStream.class, stream -> stream.headers == null ? null : connection.determineContentEncoding(stream.headers))));
    }

    private <T, R> R ifType(Object obj, Class<T> type, Function<T, R> then) {
        return obj != null && type.isAssignableFrom(obj.getClass()) ? (R)then.apply(type.cast(obj)) : null;
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        this.beforeWritingHeaders(ctx, streamId, headers);
        return this.delegate.writeHeaders(ctx, streamId, headers, padding, endStream, promise);
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream, ChannelPromise promise) {
        this.beforeWritingHeaders(ctx, streamId, headers);
        return this.delegate.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream, promise);
    }

    public void lifecycleManager(Http2LifecycleManager http2LifecycleManager) {
        this.delegate.lifecycleManager(http2LifecycleManager);
    }

    public Http2Connection connection() {
        return this.delegate.connection();
    }

    public Http2RemoteFlowController flowController() {
        return this.delegate.flowController();
    }

    public Http2FrameWriter frameWriter() {
        return this.delegate.frameWriter();
    }

    public Http2Settings pollSentSettings() {
        return this.delegate.pollSentSettings();
    }

    public void remoteSettings(Http2Settings http2Settings) throws Http2Exception {
        this.delegate.remoteSettings(http2Settings);
    }

    public ChannelFuture writePriority(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive, ChannelPromise promise) {
        return this.delegate.writePriority(ctx, streamId, streamDependency, weight, exclusive, promise);
    }

    public ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        return this.delegate.writeRstStream(ctx, streamId, errorCode, promise);
    }

    public ChannelFuture writeSettings(ChannelHandlerContext ctx, Http2Settings settings, ChannelPromise promise) {
        return this.delegate.writeSettings(ctx, settings, promise);
    }

    public ChannelFuture writeSettingsAck(ChannelHandlerContext ctx, ChannelPromise promise) {
        return this.delegate.writeSettingsAck(ctx, promise);
    }

    public ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, long data, ChannelPromise promise) {
        return this.delegate.writePing(ctx, ack, data, promise);
    }

    public ChannelFuture writePushPromise(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding, ChannelPromise promise) {
        return this.delegate.writePushPromise(ctx, streamId, promisedStreamId, headers, padding, promise);
    }

    public ChannelFuture writeGoAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData, ChannelPromise promise) {
        return this.delegate.writeGoAway(ctx, lastStreamId, errorCode, debugData, promise);
    }

    public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement, ChannelPromise promise) {
        return this.delegate.writeWindowUpdate(ctx, streamId, windowSizeIncrement, promise);
    }

    public ChannelFuture writeFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload, ChannelPromise promise) {
        return this.delegate.writeFrame(ctx, frameType, streamId, flags, payload, promise);
    }

    public Http2FrameWriter.Configuration configuration() {
        return this.delegate.configuration();
    }

    public void close() {
        this.delegate.close();
    }

    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream, ChannelPromise promise) {
        return this.delegate.writeData(ctx, streamId, data, padding, endStream, promise);
    }

    public void consumeReceivedSettings(Http2Settings settings) {
        if (!(this.delegate instanceof Http2SettingsReceivedConsumer)) {
            throw new IllegalStateException("delegate " + this.delegate + " is not an instance of " + Http2SettingsReceivedConsumer.class);
        }
        ((Http2SettingsReceivedConsumer)this.delegate).consumeReceivedSettings(settings);
    }
}

