/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.concurrent;

import io.netty.channel.EventLoop;
import io.vertx.core.streams.impl.MessageChannel;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class OutboundMessageChannel<M>
implements Predicate<M> {
    private final EventLoop eventLoop;
    private final AtomicInteger numberOfUnwritableSignals = new AtomicInteger();
    private final MessageChannel.MpSc<M> messageChannel;
    private volatile boolean eventuallyClosed;
    private boolean overflow;
    private boolean closed;
    private int reentrant = 0;

    public OutboundMessageChannel(EventLoop eventLoop, Predicate<M> predicate) {
        this.eventLoop = eventLoop;
        this.messageChannel = new MessageChannel.MpSc<M>(predicate);
    }

    public OutboundMessageChannel(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        this.messageChannel = new MessageChannel.MpSc(this);
    }

    @Override
    public boolean test(M msg) {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return this.numberOfUnwritableSignals.get() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean write(M message) {
        int flags;
        boolean inEventLoop = this.eventLoop.inEventLoop();
        if (inEventLoop) {
            if (this.closed) {
                this.disposeMessage(message);
                return true;
            }
            ++this.reentrant;
            try {
                flags = this.messageChannel.add(message);
                if ((flags & 4) != 0) {
                    flags = this.messageChannel.drain();
                    this.overflow |= (flags & 4) != 0;
                    if ((flags & 2) != 0) {
                        this.handleDrained(MessageChannel.numberOfUnwritableSignals(flags));
                    }
                }
            }
            finally {
                --this.reentrant;
            }
            if (this.reentrant == 0 && this.closed) {
                this.releaseMessages();
            }
        } else {
            if (this.eventuallyClosed) {
                this.disposeMessage(message);
                return true;
            }
            flags = this.messageChannel.add(message);
            if ((flags & 4) != 0) {
                this.eventLoop.execute(this::drainMessageChannel);
            }
        }
        if ((flags & 1) != 0) {
            int val = this.numberOfUnwritableSignals.incrementAndGet();
            return val <= 0;
        }
        return this.numberOfUnwritableSignals.get() <= 0;
    }

    public void drain() {
        assert (this.eventLoop.inEventLoop());
        if (this.overflow) {
            this.startDraining();
            ++this.reentrant;
            try {
                int flags = this.messageChannel.drain();
                boolean bl = this.overflow = (flags & 4) != 0;
                if ((flags & 2) != 0) {
                    this.handleDrained(MessageChannel.numberOfUnwritableSignals(flags));
                }
            }
            finally {
                --this.reentrant;
            }
            this.stopDraining();
            if (this.reentrant == 0 && this.closed) {
                this.releaseMessages();
            }
        }
    }

    public final void close() {
        assert (this.eventLoop.inEventLoop());
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.eventuallyClosed = true;
        if (this.reentrant > 0) {
            return;
        }
        this.releaseMessages();
    }

    private void drainMessageChannel() {
        if (this.closed) {
            return;
        }
        this.startDraining();
        ++this.reentrant;
        try {
            int flags = this.messageChannel.drain();
            boolean bl = this.overflow = (flags & 4) != 0;
            if ((flags & 2) != 0) {
                this.handleDrained(MessageChannel.numberOfUnwritableSignals(flags));
            }
        }
        finally {
            --this.reentrant;
        }
        this.stopDraining();
        if (this.reentrant == 0 && this.closed) {
            this.releaseMessages();
        }
    }

    private void handleDrained(int numberOfSignals) {
        int val = this.numberOfUnwritableSignals.addAndGet(-numberOfSignals);
        if (val + numberOfSignals > 0 && val <= 0) {
            this.afterDrain();
        }
    }

    private void releaseMessages() {
        List messages = this.messageChannel.clear();
        for (Object elt : messages) {
            this.disposeMessage(elt);
        }
    }

    protected void afterDrain() {
    }

    protected void startDraining() {
    }

    protected void stopDraining() {
    }

    protected void disposeMessage(M msg) {
    }
}

