/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.concurrent;

import io.vertx.core.impl.EventLoopExecutor;
import io.vertx.core.internal.EventExecutor;
import io.vertx.core.streams.impl.MessageChannel;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Predicate;

public class InboundMessageChannel<M>
implements Predicate<M>,
Runnable {
    private static final AtomicLongFieldUpdater<InboundMessageChannel<?>> DEMAND_UPDATER = AtomicLongFieldUpdater.newUpdater(InboundMessageChannel.class, "demand");
    private final EventExecutor consumer;
    private final EventExecutor producer;
    private final MessageChannel<M> messageChannel;
    private boolean producerClosed;
    private boolean draining;
    private boolean needsDrain;
    private boolean consumerClosed;
    private volatile long demand = Long.MAX_VALUE;

    public InboundMessageChannel(EventExecutor producer, EventExecutor consumer) {
        MessageChannel.Factory messageChannelFactory = consumer instanceof EventLoopExecutor && producer instanceof EventLoopExecutor && ((EventLoopExecutor)consumer).eventLoop() == ((EventLoopExecutor)producer).eventLoop() ? MessageChannel.SINGLE_THREAD : MessageChannel.SPSC;
        this.messageChannel = messageChannelFactory.create(this);
        this.consumer = consumer;
        this.producer = producer;
    }

    public InboundMessageChannel(EventExecutor producer, EventExecutor consumer, MessageChannel.Factory messageChannelFactory) {
        this.messageChannel = messageChannelFactory.create(this);
        this.consumer = consumer;
        this.producer = producer;
    }

    public InboundMessageChannel(EventExecutor producer, EventExecutor consumer, int lowWaterMark, int highWaterMark) {
        MessageChannel.Factory messageChannelFactory = consumer instanceof EventLoopExecutor && producer instanceof EventLoopExecutor && ((EventLoopExecutor)consumer).eventLoop() == ((EventLoopExecutor)producer).eventLoop() ? MessageChannel.SINGLE_THREAD : MessageChannel.SPSC;
        this.messageChannel = messageChannelFactory.create(this, lowWaterMark, highWaterMark);
        this.consumer = consumer;
        this.producer = producer;
    }

    @Override
    public final boolean test(M msg) {
        long d;
        if (this.consumerClosed) {
            return false;
        }
        do {
            if ((d = DEMAND_UPDATER.get(this)) != 0L) continue;
            return false;
        } while (d != Long.MAX_VALUE && !DEMAND_UPDATER.compareAndSet(this, d, d - 1L));
        this.handleMessage(msg);
        return true;
    }

    public final boolean add(M msg) {
        assert (this.producer.inThread());
        if (this.producerClosed) {
            this.handleDispose(msg);
            return false;
        }
        int res = this.messageChannel.add(msg);
        if ((res & 1) != 0) {
            this.handlePause();
        }
        return (res & 4) != 0;
    }

    public final void write(Iterable<M> messages) {
        boolean drain = false;
        for (M msg : messages) {
            drain |= this.add(msg);
        }
        if (drain) {
            this.drain();
        }
    }

    public final void write(M msg) {
        if (this.add(msg)) {
            this.drain();
        }
    }

    public final void drain() {
        assert (this.producer.inThread());
        if (this.producerClosed) {
            return;
        }
        if (this.consumer.inThread()) {
            this.drainInternal();
        } else {
            this.consumer.execute(this::drainInternal);
        }
    }

    @Override
    public void run() {
        assert (this.consumer.inThread());
        if (!this.draining && this.needsDrain) {
            this.drainInternal();
        }
    }

    private void drainInternal() {
        if (this.consumerClosed) {
            return;
        }
        this.draining = true;
        try {
            int res = this.messageChannel.drain();
            if (this.consumerClosed) {
                this.releaseMessages();
            } else {
                boolean bl = this.needsDrain = (res & 4) != 0;
                if ((res & 2) != 0) {
                    if (this.producer.inThread()) {
                        this.handleResume();
                    } else {
                        this.producer.execute(this::handleResume);
                    }
                }
            }
        }
        finally {
            this.draining = false;
        }
    }

    public final void pause() {
        DEMAND_UPDATER.set(this, 0L);
    }

    public final void fetch(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Invalid amount: " + amount);
        }
        if (amount > 0L) {
            long next;
            long prev;
            do {
                if ((next = (prev = DEMAND_UPDATER.get(this)) + amount) >= 0L) continue;
                next = Long.MAX_VALUE;
            } while (prev != next && !DEMAND_UPDATER.compareAndSet(this, prev, next));
            this.consumer.execute(this);
        }
    }

    public final void close() {
        if (!this.producer.inThread()) {
            this.producer.execute(this::close);
            return;
        }
        this.closeProducer();
        if (this.consumer.inThread()) {
            this.closeConsumer();
        } else {
            this.consumer.execute(this::closeConsumer);
        }
    }

    public final void closeProducer() {
        assert (this.producer.inThread());
        if (this.producerClosed) {
            return;
        }
        this.producerClosed = true;
    }

    public final void closeConsumer() {
        assert (this.consumer.inThread());
        if (this.consumerClosed) {
            return;
        }
        this.consumerClosed = true;
        if (!this.draining) {
            this.releaseMessages();
        }
    }

    private void releaseMessages() {
        List<M> messages = this.messageChannel.clear();
        for (M elt : messages) {
            this.handleDispose(elt);
        }
    }

    protected void handleResume() {
    }

    protected void handlePause() {
    }

    protected void handleMessage(M msg) {
    }

    protected void handleDispose(M msg) {
    }
}

