/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleStateEvent;
import io.vertx.core.Handler;
import io.vertx.core.impl.buffer.VertxByteBufAllocator;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.VertxConnection;
import java.util.function.Function;

public final class VertxHandler<C extends VertxConnection>
extends ChannelDuplexHandler {
    private final Function<ChannelHandlerContext, C> connectionFactory;
    private C conn;
    private Handler<C> addHandler;
    private Handler<C> removeHandler;

    public static <C extends VertxConnection> VertxHandler<C> create(Function<ChannelHandlerContext, C> connectionFactory) {
        return new VertxHandler<C>(connectionFactory);
    }

    private VertxHandler(Function<ChannelHandlerContext, C> connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf safeBuffer(ByteBuf byteBuf) {
        Class<?> allocClass;
        if (byteBuf != Unpooled.EMPTY_BUFFER && ((allocClass = byteBuf.alloc().getClass()) == AdaptiveByteBufAllocator.class || allocClass == PooledByteBufAllocator.class || byteBuf instanceof CompositeByteBuf)) {
            try {
                if (byteBuf.isReadable()) {
                    ByteBuf buffer = VertxByteBufAllocator.DEFAULT.heapBuffer(byteBuf.readableBytes());
                    buffer.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                    ByteBuf byteBuf2 = buffer;
                    return byteBuf2;
                }
                ByteBuf byteBuf3 = Unpooled.EMPTY_BUFFER;
                return byteBuf3;
            }
            finally {
                byteBuf.release();
            }
        }
        return byteBuf;
    }

    private void setConnection(C connection) {
        this.conn = connection;
        if (this.addHandler != null) {
            this.addHandler.handle(connection);
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.setConnection((VertxConnection)this.connectionFactory.apply(ctx));
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.removeHandler != null) {
            Handler<C> handler = this.removeHandler;
            this.removeHandler = null;
            handler.handle(this.conn);
        }
    }

    public VertxHandler<C> addHandler(Handler<C> handler) {
        this.addHandler = handler;
        return this;
    }

    public VertxHandler<C> removeHandler(Handler<C> handler) {
        this.removeHandler = handler;
        return this;
    }

    public C getConnection() {
        return this.conn;
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        C conn = this.getConnection();
        ((VertxConnection)conn).channelWritabilityChanged();
    }

    public void exceptionCaught(ChannelHandlerContext chctx, Throwable t) {
        C connection = this.getConnection();
        if (connection != null) {
            ((ConnectionBase)connection).handleException(t);
        }
        chctx.close();
    }

    public void channelInactive(ChannelHandlerContext chctx) {
        ((VertxConnection)this.conn).handleClosed();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ((VertxConnection)this.conn).endReadAndFlush();
    }

    public void channelRead(ChannelHandlerContext chctx, Object msg) {
        ((VertxConnection)this.conn).read(msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ((ConnectionBase)this.conn).handleClose(promise);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ((VertxConnection)this.conn).handleIdle((IdleStateEvent)evt);
        }
        ((VertxConnection)this.conn).handleEvent(evt);
    }
}

