/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.DuplicatedContext;
import io.vertx.core.impl.ShadowContext;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.WorkerExecutorInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.lang.ref.Cleaner;
import java.util.concurrent.Callable;

class WorkerExecutorImpl
implements MetricsProvider,
WorkerExecutorInternal {
    private final VertxInternal vertx;
    private final WorkerPool pool;
    private final Cleaner.Cleanable cleanable;

    public WorkerExecutorImpl(VertxInternal vertx, Cleaner cleaner, WorkerPool pool) {
        this.vertx = vertx;
        this.pool = pool;
        this.cleanable = cleaner.register(this, pool::close);
    }

    @Override
    public Metrics getMetrics() {
        return this.pool.metrics();
    }

    @Override
    public boolean isMetricsEnabled() {
        PoolMetrics metrics = this.pool.metrics();
        return metrics != null;
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public WorkerPool getPool() {
        return this.pool;
    }

    @Override
    public <T> Future<@Nullable T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        TaskQueue orderedTasks;
        ContextInternal context = this.vertx.getOrCreateContext();
        if (ordered) {
            if (context instanceof ShadowContext) {
                orderedTasks = ((ShadowContext)context).orderedTasks;
            } else {
                ContextImpl impl = context instanceof DuplicatedContext ? ((DuplicatedContext)context).delegate : (ContextImpl)context;
                orderedTasks = impl.executeBlockingTasks;
            }
        } else {
            orderedTasks = null;
        }
        return this.pool.executeBlocking(context, blockingCodeHandler, orderedTasks);
    }

    @Override
    public Future<Void> close() {
        this.cleanable.clean();
        return this.vertx.getOrCreateContext().succeededFuture();
    }
}

