/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ThreadExecutorMap;
import io.vertx.core.Closeable;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.datagram.impl.DatagramSocketImpl;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.dns.impl.DnsAddressResolverProvider;
import io.vertx.core.dns.impl.DnsClientImpl;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.EventBusInternal;
import io.vertx.core.eventbus.impl.clustered.ClusteredEventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.impl.FileSystemImpl;
import io.vertx.core.file.impl.WindowsFileSystem;
import io.vertx.core.http.HttpClientBuilder;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.http.impl.CleanableWebSocketClient;
import io.vertx.core.http.impl.HttpClientBuilderInternal;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.http.impl.WebSocketClientImpl;
import io.vertx.core.impl.ContextBase;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextLocalImpl;
import io.vertx.core.impl.EventLoopExecutor;
import io.vertx.core.impl.FailoverCompleteHandler;
import io.vertx.core.impl.HAManager;
import io.vertx.core.impl.HostnameResolver;
import io.vertx.core.impl.LocalSeq;
import io.vertx.core.impl.ShadowContext;
import io.vertx.core.impl.SharedResourceHolder;
import io.vertx.core.impl.ThreadPerTaskExecutorService;
import io.vertx.core.impl.Utils;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.WorkerExecutor;
import io.vertx.core.impl.WorkerExecutorImpl;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.WorkerTaskQueue;
import io.vertx.core.impl.deployment.DefaultDeploymentManager;
import io.vertx.core.impl.deployment.Deployment;
import io.vertx.core.impl.deployment.DeploymentContext;
import io.vertx.core.impl.deployment.DeploymentManager;
import io.vertx.core.impl.transports.NioTransport;
import io.vertx.core.impl.verticle.VerticleManager;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.net.NetClientInternal;
import io.vertx.core.internal.threadchecker.BlockedThreadChecker;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.impl.CleanableNetClient;
import io.vertx.core.net.impl.NetClientBuilder;
import io.vertx.core.net.impl.NetServerImpl;
import io.vertx.core.net.impl.NetServerInternal;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.shareddata.impl.SharedDataImpl;
import io.vertx.core.spi.ExecutorServiceFactory;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.spi.VertxThreadFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.impl.NodeSelector;
import io.vertx.core.spi.context.executor.EventExecutorProvider;
import io.vertx.core.spi.context.storage.AccessMode;
import io.vertx.core.spi.context.storage.ContextLocal;
import io.vertx.core.spi.file.FileResolver;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.spi.transport.Transport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class VertxImpl
implements VertxInternal,
MetricsProvider {
    private static String version;
    private static final Cleaner cleaner;
    static final ThreadLocal<ContextDispatch> nonVertxContextDispatch;
    private static final Logger log;
    static final Object[] EMPTY_CONTEXT_LOCALS;
    private static final String CLUSTER_MAP_NAME = "__vertx.haInfo";
    private static final String NETTY_IO_RATIO_PROPERTY_NAME = "vertx.nettyIORatio";
    private static final int NETTY_IO_RATIO;
    private final FileSystem fileSystem = this.getFileSystem();
    private final SharedData sharedData;
    private final VertxMetrics metrics;
    private final ConcurrentMap<Long, InternalTimerHandler> timeouts = new ConcurrentHashMap<Long, InternalTimerHandler>();
    private final AtomicLong timeoutCounter = new AtomicLong(0L);
    private final ClusterManager clusterManager;
    private final NodeSelector nodeSelector;
    private final DeploymentManager deploymentManager;
    private final VerticleManager verticleManager;
    private final FileResolver fileResolver;
    private final EventExecutorProvider eventExecutorProvider;
    private final Map<ServerID, NetServerInternal> sharedNetServers = new HashMap<ServerID, NetServerInternal>();
    private final ContextLocal<?>[] contextLocals;
    private final List<ContextLocal<?>> contextLocalsList;
    final WorkerPool workerPool;
    final WorkerPool internalWorkerPool;
    final WorkerPool virtualThreaWorkerPool;
    private final VertxThreadFactory threadFactory;
    private final ExecutorServiceFactory executorServiceFactory;
    private final ThreadFactory eventLoopThreadFactory;
    private final EventLoopGroup eventLoopGroup;
    private final EventLoopGroup acceptorEventLoopGroup;
    private final ExecutorService virtualThreadExecutor;
    private final BlockedThreadChecker checker;
    private final HostnameResolver hostnameResolver;
    private final AddressResolverOptions addressResolverOptions;
    private final EventBusInternal eventBus;
    private volatile HAManager haManager;
    private boolean closed;
    private volatile Handler<Throwable> exceptionHandler;
    private final int defaultWorkerPoolSize;
    private final long maxWorkerExecTime;
    private final TimeUnit maxWorkerExecTimeUnit;
    private final long maxEventLoopExecTime;
    private final TimeUnit maxEventLoopExecTimeUnit;
    private final CloseFuture closeFuture;
    private final Transport transport;
    private final Throwable transportUnavailabilityCause;
    private final VertxTracer tracer;
    private final ThreadLocal<WeakReference<EventLoop>> stickyEventLoop = new ThreadLocal();
    private final boolean disableTCCL;
    private final Boolean useDaemonThread;

    private static ThreadFactory virtualThreadFactory() {
        try {
            Class<?> builderClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.Thread$Builder");
            Class<?> ofVirtualClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.Thread$Builder$OfVirtual");
            Method ofVirtualMethod = Thread.class.getDeclaredMethod("ofVirtual", new Class[0]);
            Object builder = ofVirtualMethod.invoke(null, new Object[0]);
            Method nameMethod = ofVirtualClass.getDeclaredMethod("name", String.class, Long.TYPE);
            Method factoryMethod = builderClass.getDeclaredMethod("factory", new Class[0]);
            builder = nameMethod.invoke(builder, "vert.x-virtual-thread-", 0L);
            return (ThreadFactory)factoryMethod.invoke(builder, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    VertxImpl(VertxOptions options, ClusterManager clusterManager, NodeSelector nodeSelector, VertxMetrics metrics, VertxTracer<?, ?> tracer, Transport transport, Throwable transportUnavailabilityCause, FileResolver fileResolver, VertxThreadFactory threadFactory, ExecutorServiceFactory executorServiceFactory, EventExecutorProvider eventExecutorProvider) {
        if (Vertx.currentContext() != null) {
            log.warn((Object)"You're already on a Vert.x context, are you sure you want to create a new Vertx instance?");
        }
        Boolean useDaemonThread = options.getUseDaemonThread();
        int workerPoolSize = options.getWorkerPoolSize();
        int internalBlockingPoolSize = options.getInternalBlockingPoolSize();
        BlockedThreadChecker checker = new BlockedThreadChecker(options.getBlockedThreadCheckInterval(), options.getBlockedThreadCheckIntervalUnit(), options.getWarningExceptionTime(), options.getWarningExceptionTimeUnit());
        long maxEventLoopExecuteTime = options.getMaxEventLoopExecuteTime();
        TimeUnit maxEventLoopExecuteTimeUnit = options.getMaxEventLoopExecuteTimeUnit();
        ThreadFactory acceptorEventLoopThreadFactory = this.createThreadFactory(threadFactory, checker, useDaemonThread, maxEventLoopExecuteTime, maxEventLoopExecuteTimeUnit, "vert.x-acceptor-thread-", false);
        TimeUnit maxWorkerExecuteTimeUnit = options.getMaxWorkerExecuteTimeUnit();
        long maxWorkerExecuteTime = options.getMaxWorkerExecuteTime();
        ThreadFactory workerThreadFactory = this.createThreadFactory(threadFactory, checker, useDaemonThread, maxWorkerExecuteTime, maxWorkerExecuteTimeUnit, "vert.x-worker-thread-", true);
        ExecutorService workerExec = executorServiceFactory.createExecutor(workerThreadFactory, workerPoolSize, workerPoolSize);
        PoolMetrics<?, ?> workerPoolMetrics = metrics != null ? metrics.createPoolMetrics("worker", "vert.x-worker-thread", options.getWorkerPoolSize()) : null;
        ThreadFactory internalWorkerThreadFactory = this.createThreadFactory(threadFactory, checker, useDaemonThread, maxWorkerExecuteTime, maxWorkerExecuteTimeUnit, "vert.x-internal-blocking-", true);
        ExecutorService internalWorkerExec = executorServiceFactory.createExecutor(internalWorkerThreadFactory, internalBlockingPoolSize, internalBlockingPoolSize);
        PoolMetrics<?, ?> internalBlockingPoolMetrics = metrics != null ? metrics.createPoolMetrics("worker", "vert.x-internal-blocking", internalBlockingPoolSize) : null;
        ThreadFactory virtualThreadFactory = VertxImpl.virtualThreadFactory();
        this.contextLocals = LocalSeq.get();
        this.contextLocalsList = Collections.unmodifiableList(Arrays.asList(this.contextLocals));
        this.closeFuture = new CloseFuture(log);
        this.maxEventLoopExecTime = maxEventLoopExecuteTime;
        this.maxEventLoopExecTimeUnit = maxEventLoopExecuteTimeUnit;
        this.eventLoopThreadFactory = this.createThreadFactory(threadFactory, checker, useDaemonThread, this.maxEventLoopExecTime, this.maxEventLoopExecTimeUnit, "vert.x-eventloop-thread-", false);
        this.eventLoopGroup = transport.eventLoopGroup(1, options.getEventLoopPoolSize(), this.eventLoopThreadFactory, NETTY_IO_RATIO);
        this.acceptorEventLoopGroup = transport.eventLoopGroup(0, 1, acceptorEventLoopThreadFactory, 100);
        this.virtualThreadExecutor = virtualThreadFactory != null ? new ThreadPerTaskExecutorService(virtualThreadFactory) : null;
        this.virtualThreaWorkerPool = virtualThreadFactory != null ? new WorkerPool(this.virtualThreadExecutor, null) : null;
        this.internalWorkerPool = new WorkerPool(internalWorkerExec, internalBlockingPoolMetrics);
        this.workerPool = new WorkerPool(workerExec, workerPoolMetrics);
        this.defaultWorkerPoolSize = options.getWorkerPoolSize();
        this.maxWorkerExecTime = maxWorkerExecuteTime;
        this.maxWorkerExecTimeUnit = maxWorkerExecuteTimeUnit;
        this.disableTCCL = options.getDisableTCCL();
        this.checker = checker;
        this.useDaemonThread = useDaemonThread;
        this.executorServiceFactory = executorServiceFactory;
        this.threadFactory = threadFactory;
        this.metrics = metrics;
        this.transport = transport;
        this.transportUnavailabilityCause = transportUnavailabilityCause;
        this.fileResolver = fileResolver;
        this.addressResolverOptions = options.getAddressResolverOptions();
        this.hostnameResolver = new HostnameResolver(this, options.getAddressResolverOptions());
        this.tracer = tracer == VertxTracer.NOOP ? null : tracer;
        this.clusterManager = clusterManager;
        this.nodeSelector = nodeSelector;
        this.eventBus = clusterManager != null ? new ClusteredEventBus(this, options, clusterManager, nodeSelector) : new EventBusImpl(this);
        this.sharedData = new SharedDataImpl(this, clusterManager);
        this.deploymentManager = new DefaultDeploymentManager(this);
        this.verticleManager = new VerticleManager(this, DefaultDeploymentManager.log, this.deploymentManager);
        this.eventExecutorProvider = eventExecutorProvider;
    }

    void init() {
        this.eventBus.start(Promise.promise());
        if (this.metrics != null) {
            this.metrics.vertxCreated(this);
        }
    }

    Future<Vertx> initClustered(VertxOptions options) {
        this.nodeSelector.init(this, this.clusterManager);
        this.clusterManager.registrationListener(this.nodeSelector);
        this.clusterManager.init(this);
        Promise initPromise = Promise.promise();
        Promise<Void> joinPromise = Promise.promise();
        joinPromise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                this.createHaManager(options, initPromise);
            } else {
                initPromise.fail(ar.cause());
            }
        });
        this.clusterManager.join(joinPromise);
        return initPromise.future().transform(ar -> {
            if (ar.succeeded()) {
                if (this.metrics != null) {
                    this.metrics.vertxCreated(this);
                }
                return Future.succeededFuture(this);
            }
            log.error((Object)"Failed to initialize clustered Vert.x", ar.cause());
            return this.close().transform(v -> Future.failedFuture(ar.cause()));
        });
    }

    private void createHaManager(VertxOptions options, Promise<Void> initPromise) {
        if (options.isHAEnabled()) {
            this.executeBlocking(() -> {
                this.haManager = new HAManager(this, this.deploymentManager, this.verticleManager, this.clusterManager, this.clusterManager.getSyncMap(CLUSTER_MAP_NAME), options.getQuorumSize(), options.getHAGroup());
                return this.haManager;
            }, false).onComplete(ar -> {
                if (ar.succeeded()) {
                    this.startEventBus(true, initPromise);
                } else {
                    initPromise.fail(ar.cause());
                }
            });
        } else {
            this.startEventBus(false, initPromise);
        }
    }

    private void startEventBus(boolean haEnabled, Promise<Void> initPromise) {
        Promise<Void> promise = Promise.promise();
        this.eventBus.start(promise);
        promise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                if (haEnabled) {
                    this.initializeHaManager(initPromise);
                } else {
                    initPromise.complete();
                }
            } else {
                initPromise.fail(ar.cause());
            }
        });
    }

    private void initializeHaManager(Promise<Void> initPromise) {
        this.executeBlocking(() -> {
            this.haManager.init();
            return null;
        }, false).onComplete(initPromise);
    }

    protected FileSystem getFileSystem() {
        return Utils.isWindows() ? new WindowsFileSystem(this) : new FileSystemImpl(this);
    }

    @Override
    public long maxEventLoopExecTime() {
        return this.maxEventLoopExecTime;
    }

    @Override
    public TimeUnit maxEventLoopExecTimeUnit() {
        return this.maxEventLoopExecTimeUnit;
    }

    @Override
    public DatagramSocket createDatagramSocket(DatagramSocketOptions options) {
        CloseFuture closeFuture = new CloseFuture(log);
        DatagramSocketImpl so = DatagramSocketImpl.create(this, closeFuture, options);
        closeFuture.add(so);
        CloseFuture fut = this.resolveCloseFuture();
        fut.add(closeFuture);
        return so;
    }

    @Override
    public NetServerImpl createNetServer(NetServerOptions options) {
        return new NetServerImpl(this, options.copy());
    }

    @Override
    public NetClient createNetClient(NetClientOptions options) {
        CloseFuture fut = this.resolveCloseFuture();
        NetClientBuilder builder = new NetClientBuilder(this, options);
        builder.metrics(this.metricsSPI() != null ? this.metricsSPI().createNetClientMetrics(options) : null);
        NetClientInternal netClient = builder.build();
        fut.add(netClient);
        return new CleanableNetClient(netClient, cleaner);
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    @Override
    public Cleaner cleaner() {
        return cleaner;
    }

    @Override
    public boolean isNativeTransportEnabled() {
        return !(this.transport instanceof NioTransport);
    }

    @Override
    public Throwable unavailableNativeTransportCause() {
        if (this.isNativeTransportEnabled()) {
            return null;
        }
        return this.transportUnavailabilityCause;
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public SharedData sharedData() {
        return this.sharedData;
    }

    @Override
    public HttpServer createHttpServer(HttpServerOptions serverOptions) {
        return new HttpServerImpl(this, serverOptions);
    }

    @Override
    public WebSocketClient createWebSocketClient(WebSocketClientOptions options) {
        Closeable closeable;
        WebSocketClient client;
        HttpClientOptions o = new HttpClientOptions(options);
        o.setDefaultHost(options.getDefaultHost());
        o.setDefaultPort(options.getDefaultPort());
        o.setVerifyHost(options.isVerifyHost());
        o.setShared(options.isShared());
        o.setName(options.getName());
        CloseFuture cf = this.resolveCloseFuture();
        if (options.isShared()) {
            CloseFuture closeFuture = new CloseFuture();
            client = this.createSharedResource("__vertx.shared.webSocketClients", options.getName(), closeFuture, cf_ -> {
                WebSocketClientImpl impl = new WebSocketClientImpl(this, o, options);
                cf_.add(completion -> impl.close().onComplete(completion));
                return impl;
            });
            client = new CleanableWebSocketClient(client, cleaner, (timeout, timeunit) -> closeFuture.close());
            closeable = closeFuture;
        } else {
            WebSocketClientImpl impl;
            closeable = impl = new WebSocketClientImpl(this, o, options);
            client = new CleanableWebSocketClient(impl, cleaner, impl::shutdown);
        }
        cf.add(closeable);
        return client;
    }

    @Override
    public HttpClientBuilder httpClientBuilder() {
        return new HttpClientBuilderInternal(this);
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public long setPeriodic(long initialDelay, long delay, Handler<Long> handler) {
        ContextInternal ctx = this.getOrCreateContext();
        return this.scheduleTimeout(ctx.unwrap(), true, initialDelay, delay, TimeUnit.MILLISECONDS, ctx.isDeployment(), handler);
    }

    @Override
    public long setTimer(long delay, Handler<Long> handler) {
        ContextInternal ctx = this.getOrCreateContext();
        return this.scheduleTimeout(ctx, false, delay, TimeUnit.MILLISECONDS, ctx.isDeployment(), handler);
    }

    @Override
    public WorkerPool getWorkerPool() {
        return this.workerPool;
    }

    @Override
    public WorkerPool getInternalWorkerPool() {
        return this.internalWorkerPool;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public EventLoopGroup getAcceptorEventLoopGroup() {
        return this.acceptorEventLoopGroup;
    }

    public static ContextInternal currentContext(Thread thread) {
        if (thread instanceof VertxThread) {
            return ((VertxThread)((Object)thread)).context();
        }
        ContextDispatch current = nonVertxContextDispatch.get();
        if (current != null) {
            return current.context;
        }
        return null;
    }

    @Override
    public ContextInternal getOrCreateContext() {
        Thread thread = Thread.currentThread();
        ContextInternal ctx = this.getContext(thread);
        if (ctx == null) {
            return this.createContext(thread);
        }
        return ctx;
    }

    private ContextInternal createContext(Thread thread) {
        Executor executor;
        if (thread instanceof VertxThread && ((VertxThread)((Object)thread)).owner == this) {
            if (((VertxThread)((Object)thread)).isWorker()) {
                return this.createWorkerContext(this.eventLoopGroup.next(), this.workerPool, null);
            }
            EventExecutor eventLoop = ThreadExecutorMap.currentExecutor();
            return this.createEventLoopContext((EventLoop)eventLoop, this.workerPool, null);
        }
        EventLoop eventLoop = this.stickyEventLoop();
        EventLoopExecutor eventLoopExecutor = new EventLoopExecutor(eventLoop);
        io.vertx.core.internal.EventExecutor eventExecutor = null;
        if (this.eventExecutorProvider != null && (executor = this.eventExecutorProvider.eventExecutorFor(thread)) != null) {
            eventExecutor = new io.vertx.core.internal.EventExecutor(){
                final ThreadLocal<Boolean> inThread = new ThreadLocal();

                @Override
                public boolean inThread() {
                    return this.inThread.get() != null;
                }

                @Override
                public void execute(Runnable command) {
                    executor.execute(() -> {
                        this.inThread.set(true);
                        try {
                            command.run();
                        }
                        finally {
                            this.inThread.remove();
                        }
                    });
                }
            };
        }
        ContextInternal ctx = eventExecutor != null ? this.createContext(ThreadingModel.OTHER, eventLoopExecutor, eventExecutor, this.workerPool, this.closeFuture, null, Thread.currentThread().getContextClassLoader()) : this.createEventLoopContext(eventLoop, this.workerPool, Thread.currentThread().getContextClassLoader());
        return ctx;
    }

    private EventLoop stickyEventLoop() {
        WeakReference<EventLoop> r = this.stickyEventLoop.get();
        EventLoop eventLoop = r != null ? (EventLoop)r.get() : null;
        if (eventLoop == null) {
            eventLoop = this.eventLoopGroup.next();
            this.stickyEventLoop.set(new WeakReference<EventLoop>(eventLoop));
        }
        return eventLoop;
    }

    @Override
    public Map<ServerID, NetServerInternal> sharedTcpServers() {
        return this.sharedNetServers;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public boolean cancelTimer(long id) {
        InternalTimerHandler handler = (InternalTimerHandler)this.timeouts.get(id);
        if (handler != null) {
            return handler.cancel();
        }
        return false;
    }

    private Object[] createContextLocals() {
        if (this.contextLocals.length == 0) {
            return EMPTY_CONTEXT_LOCALS;
        }
        return new Object[this.contextLocals.length];
    }

    @Override
    public ContextImpl createContext(ThreadingModel threadingModel, EventLoop eventLoop, CloseFuture closeFuture, WorkerPool workerPool, DeploymentContext deployment, ClassLoader tccl) {
        io.vertx.core.internal.EventExecutor eventExecutor;
        WorkerPool wp;
        EventLoopExecutor eventLoopExecutor = new EventLoopExecutor(eventLoop);
        switch (threadingModel) {
            case EVENT_LOOP: {
                wp = workerPool != null ? workerPool : this.workerPool;
                eventExecutor = eventLoopExecutor;
                break;
            }
            case WORKER: {
                wp = workerPool != null ? workerPool : this.workerPool;
                eventExecutor = new WorkerExecutor(wp, new WorkerTaskQueue());
                break;
            }
            case VIRTUAL_THREAD: {
                if (!this.isVirtualThreadAvailable()) {
                    throw new IllegalStateException("This Java runtime does not support virtual threads");
                }
                wp = this.virtualThreaWorkerPool;
                eventExecutor = new WorkerExecutor(this.virtualThreaWorkerPool, new WorkerTaskQueue());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return this.createContext(threadingModel, eventLoopExecutor, eventExecutor, wp, closeFuture, deployment, tccl);
    }

    public ContextImpl createContext(ThreadingModel threadingModel, EventLoopExecutor eventLoopExecutor, io.vertx.core.internal.EventExecutor eventExecutor, WorkerPool workerPool, CloseFuture closeFuture, DeploymentContext deployment, ClassLoader tccl) {
        return new ContextImpl(this, this.createContextLocals(), eventLoopExecutor, threadingModel, eventExecutor, workerPool, deployment, closeFuture, this.disableTCCL ? null : tccl);
    }

    @Override
    public DnsClient createDnsClient(int port, String host) {
        return this.createDnsClient(new DnsClientOptions().setHost(host).setPort(port));
    }

    @Override
    public DnsClient createDnsClient() {
        return this.createDnsClient(new DnsClientOptions());
    }

    @Override
    public DnsClient createDnsClient(DnsClientOptions options) {
        String host = options.getHost();
        int port = options.getPort();
        if (host == null || port < 0) {
            DnsAddressResolverProvider provider = DnsAddressResolverProvider.create(this, this.addressResolverOptions);
            InetSocketAddress address = provider.nameServerAddresses().get(0);
            options = new DnsClientOptions(options).setHost(address.getAddress().getHostAddress()).setPort(address.getPort());
        }
        return new DnsClientImpl(this, options);
    }

    private long scheduleTimeout(ContextInternal context, boolean periodic, long initialDelay, long delay, TimeUnit timeUnit, boolean addCloseHook, Handler<Long> handler) {
        if (delay < 1L) {
            throw new IllegalArgumentException("Cannot schedule a timer with delay < 1 ms");
        }
        if (initialDelay < 0L) {
            throw new IllegalArgumentException("Cannot schedule a timer with initialDelay < 0");
        }
        long timerId = this.timeoutCounter.getAndIncrement();
        InternalTimerHandler task = new InternalTimerHandler(timerId, handler, periodic, context);
        this.timeouts.put(timerId, task);
        if (addCloseHook) {
            context.addCloseHook(task);
        }
        EventLoop el = context.nettyEventLoop();
        task.future = periodic ? el.scheduleAtFixedRate((Runnable)task, initialDelay, delay, timeUnit) : el.schedule((Runnable)task, delay, timeUnit);
        return task.id;
    }

    public long scheduleTimeout(ContextInternal context, boolean periodic, long delay, TimeUnit timeUnit, boolean addCloseHook, Handler<Long> handler) {
        return this.scheduleTimeout(context, periodic, delay, delay, timeUnit, addCloseHook, handler);
    }

    @Override
    public ContextInternal getContext() {
        return this.getContext(Thread.currentThread());
    }

    private ContextInternal getContext(Thread thread) {
        ContextInternal context = VertxImpl.currentContext(thread);
        if (context != null) {
            if (context.owner() == this) {
                return context;
            }
            if (context instanceof ShadowContext) {
                ShadowContext shadowContext = (ShadowContext)context;
                if (shadowContext.owner == this) {
                    return shadowContext;
                }
                if (shadowContext.delegate.owner() == this) {
                    return shadowContext.delegate;
                }
                throw new UnsupportedOperationException("????");
            }
            EventLoop eventLoop = this.stickyEventLoop();
            return new ShadowContext(this, new EventLoopExecutor(eventLoop), context);
        }
        return null;
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    private Future<Void> closeClusterManager() {
        Future fut;
        if (this.clusterManager != null) {
            PromiseInternal<Void> leavePromise = this.getOrCreateContext().promise();
            this.clusterManager.leave(leavePromise);
            fut = leavePromise.future();
        } else {
            fut = this.getOrCreateContext().succeededFuture();
        }
        return fut.transform(ar -> {
            if (ar.failed()) {
                log.error((Object)"Failed to leave cluster", ar.cause());
            }
            return Future.succeededFuture();
        });
    }

    @Override
    public synchronized Future<Void> close() {
        if (this.closed || this.eventBus == null) {
            return Future.succeededFuture();
        }
        this.closed = true;
        Future fut = this.closeFuture.close().transform(ar -> this.deploymentManager.undeployAll());
        if (this.haManager != null) {
            fut = fut.transform(ar -> this.executeBlocking(() -> {
                this.haManager.stop();
                return null;
            }, false));
        }
        Future val = fut = fut.transform(ar -> this.hostnameResolver.close()).transform(ar -> Future.future(h -> this.eventBus.close((Promise<Void>)h))).transform(ar -> this.closeClusterManager()).transform(ar -> {
            Promise<Void> promise = Promise.promise();
            this.deleteCacheDirAndShutdown(promise);
            return promise.future();
        });
        Promise p = Promise.promise();
        val.onComplete(ar -> this.eventLoopThreadFactory.newThread(() -> {
            if (ar.succeeded()) {
                p.complete();
            } else {
                p.fail(ar.cause());
            }
        }).start());
        return p.future();
    }

    @Override
    public Future<String> deployVerticle(Class<? extends Deployable> verticleClass, DeploymentOptions options) {
        Callable<Deployable> adapter = () -> (Deployable)verticleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return this.deployVerticle(adapter, options);
    }

    @Override
    public Future<String> deployVerticle(Supplier<? extends Deployable> supplier, DeploymentOptions options) {
        Callable<Deployable> adapter = supplier::get;
        return this.deployVerticle(adapter, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<String> deployVerticle(Callable<? extends Deployable> supplier, DeploymentOptions options) {
        Deployment deployment;
        boolean closed;
        VertxImpl vertxImpl = this;
        synchronized (vertxImpl) {
            closed = this.closed;
        }
        if (closed) {
            return Future.failedFuture("Vert.x closed");
        }
        ContextInternal currentContext = this.getOrCreateContext();
        if (options.getInstances() < 1) {
            throw new IllegalArgumentException("Can't specify < 1 instances to deploy");
        }
        ClassLoader cl = options.getClassLoader();
        if (cl == null && (cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            deployment = Deployment.deployment(this, log, options, v -> "java:" + v.getClass().getName(), cl, supplier);
        }
        catch (Exception e) {
            return currentContext.failedFuture(e);
        }
        return this.deploymentManager.deploy(currentContext.deployment(), currentContext, deployment).map(DeploymentContext::deploymentID);
    }

    @Override
    public Future<String> deployVerticle(String name, DeploymentOptions options) {
        if (options.isHa() && this.haManager() != null) {
            PromiseInternal<String> promise = this.getOrCreateContext().promise();
            this.haManager().deployVerticle(name, options, promise);
            return promise.future();
        }
        return this.verticleManager.deployVerticle(name, options).map(DeploymentContext::deploymentID);
    }

    @Override
    public Future<Void> undeploy(String deploymentID) {
        HAManager haManager = this.haManager();
        Future<Void> future = haManager != null ? this.executeBlocking(() -> {
            haManager.removeFromHA(deploymentID);
            return null;
        }, false) : this.getOrCreateContext().succeededFuture();
        return future.compose(v -> this.deploymentManager.undeploy(deploymentID));
    }

    @Override
    public Set<String> deploymentIDs() {
        return this.deploymentManager.deployments().stream().map(DeploymentContext::deploymentID).collect(Collectors.toSet());
    }

    @Override
    public void registerVerticleFactory(VerticleFactory factory) {
        this.verticleManager.registerVerticleFactory(factory);
    }

    @Override
    public void unregisterVerticleFactory(VerticleFactory factory) {
        this.verticleManager.unregisterVerticleFactory(factory);
    }

    @Override
    public Set<VerticleFactory> verticleFactories() {
        return this.verticleManager.verticleFactories();
    }

    @Override
    public boolean isClustered() {
        return this.clusterManager != null;
    }

    @Override
    public EventLoopGroup nettyEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public void simulateKill() {
        if (this.haManager() != null) {
            this.haManager().simulateKill();
        }
    }

    @Override
    public DeploymentContext getDeployment(String deploymentID) {
        return this.deploymentManager.getDeployment(deploymentID);
    }

    @Override
    public synchronized void failoverCompleteHandler(FailoverCompleteHandler failoverCompleteHandler) {
        if (this.haManager() != null) {
            this.haManager().setFailoverCompleteHandler(failoverCompleteHandler);
        }
    }

    @Override
    public boolean isKilled() {
        return this.haManager().isKilled();
    }

    @Override
    public void failDuringFailover(boolean fail) {
        if (this.haManager() != null) {
            this.haManager().failDuringFailover(fail);
        }
    }

    @Override
    public VertxMetrics metricsSPI() {
        return this.metrics;
    }

    @Override
    public File resolveFile(String fileName) {
        return this.fileResolver.resolveFile(fileName);
    }

    @Override
    public Future<InetAddress> resolveAddress(String hostname) {
        return this.hostnameResolver.resolveHostname(hostname);
    }

    @Override
    public HostnameResolver hostnameResolver() {
        return this.hostnameResolver;
    }

    @Override
    public DnsAddressResolverProvider dnsAddressResolverProvider(InetSocketAddress addr) {
        AddressResolverOptions options = new AddressResolverOptions(this.addressResolverOptions);
        options.setServers(Collections.singletonList(addr.getHostString() + ":" + addr.getPort()));
        options.setOptResourceEnabled(false);
        return DnsAddressResolverProvider.create(this, options);
    }

    @Override
    public AddressResolverGroup<InetSocketAddress> nettyAddressResolverGroup() {
        return this.hostnameResolver.nettyAddressResolverGroup();
    }

    @Override
    public List<ContextLocal<?>> contextLocals() {
        return this.contextLocalsList;
    }

    @Override
    public FileResolver fileResolver() {
        return this.fileResolver;
    }

    @Override
    public BlockedThreadChecker blockedThreadChecker() {
        return this.checker;
    }

    private void deleteCacheDirAndShutdown(final Promise<Void> promise) {
        this.executeBlockingInternal(() -> {
            this.fileResolver.close();
            return null;
        }).onComplete(ar -> {
            this.workerPool.close();
            this.internalWorkerPool.close();
            List<WorkerPool> objects = SharedResourceHolder.clearSharedResource(this, "__vertx.shared.workerPools");
            for (WorkerPool workerPool : objects) {
                workerPool.close();
            }
            if (this.virtualThreadExecutor != null) {
                this.virtualThreadExecutor.shutdown();
                try {
                    this.virtualThreadExecutor.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.acceptorEventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).addListener(new GenericFutureListener(){

                public void operationComplete(io.netty.util.concurrent.Future future) throws Exception {
                    if (!future.isSuccess()) {
                        log.warn((Object)"Failure in shutting down acceptor event loop group", future.cause());
                    }
                    VertxImpl.this.eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).addListener(new GenericFutureListener(){

                        public void operationComplete(io.netty.util.concurrent.Future future) throws Exception {
                            if (!future.isSuccess()) {
                                log.warn((Object)"Failure in shutting down event loop group", future.cause());
                            }
                            if (VertxImpl.this.metrics != null) {
                                VertxImpl.this.metrics.close();
                            }
                            if (VertxImpl.this.tracer != null) {
                                VertxImpl.this.tracer.close();
                            }
                            VertxImpl.this.checker.close();
                            VertxImpl.this.eventLoopThreadFactory.newThread(promise::complete).start();
                        }
                    });
                }
            });
        });
    }

    @Override
    public HAManager haManager() {
        return this.haManager;
    }

    @Override
    public WorkerExecutorImpl createSharedWorkerExecutor(String name) {
        return this.createSharedWorkerExecutor(name, this.defaultWorkerPoolSize);
    }

    @Override
    public WorkerExecutorImpl createSharedWorkerExecutor(String name, int poolSize) {
        return this.createSharedWorkerExecutor(name, poolSize, this.maxWorkerExecTime);
    }

    @Override
    public synchronized WorkerExecutorImpl createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime) {
        return this.createSharedWorkerExecutor(name, poolSize, maxExecuteTime, this.maxWorkerExecTimeUnit);
    }

    @Override
    public synchronized WorkerExecutorImpl createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        CloseFuture execCf = new CloseFuture();
        WorkerPool sharedWorkerPool = this.createSharedWorkerPool(execCf, name, poolSize, maxExecuteTime, maxExecuteTimeUnit);
        CloseFuture parentCf = this.resolveCloseFuture();
        parentCf.add(execCf);
        return new WorkerExecutorImpl(this, cleaner, sharedWorkerPool);
    }

    @Override
    public WorkerPool createSharedWorkerPool(String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        return this.createSharedWorkerPool(new CloseFuture(), name, poolSize, maxExecuteTime, maxExecuteTimeUnit);
    }

    private synchronized WorkerPool createSharedWorkerPool(final CloseFuture closeFuture, String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize must be > 0");
        }
        if (maxExecuteTime < 1L) {
            throw new IllegalArgumentException("maxExecuteTime must be > 0");
        }
        WorkerPool shared = this.createSharedResource("__vertx.shared.workerPools", name, closeFuture, cf -> {
            ThreadFactory workerThreadFactory = this.createThreadFactory(this.threadFactory, this.checker, this.useDaemonThread, maxExecuteTime, maxExecuteTimeUnit, name + "-", true);
            ExecutorService workerExec = this.executorServiceFactory.createExecutor(workerThreadFactory, poolSize, poolSize);
            PoolMetrics<?, ?> workerMetrics = this.metrics != null ? this.metrics.createPoolMetrics("worker", name, poolSize) : null;
            WorkerPool pool = new WorkerPool(workerExec, workerMetrics);
            cf.add(completion -> {
                pool.close();
                completion.complete();
            });
            return pool;
        });
        return new WorkerPool(shared.executor(), shared.metrics()){

            @Override
            public void close() {
                closeFuture.close();
            }
        };
    }

    @Override
    public WorkerPool wrapWorkerPool(ExecutorService executor) {
        PoolMetrics<?, ?> workerMetrics = this.metrics != null ? this.metrics.createPoolMetrics("worker", null, -1) : null;
        return new WorkerPool(executor, workerMetrics);
    }

    private ThreadFactory createThreadFactory(VertxThreadFactory threadFactory, BlockedThreadChecker checker, Boolean useDaemonThread, long maxExecuteTime, TimeUnit maxExecuteTimeUnit, String prefix, boolean worker) {
        AtomicInteger threadCount = new AtomicInteger(0);
        return runnable -> {
            VertxThread thread = threadFactory.newVertxThread(runnable, prefix + threadCount.getAndIncrement(), worker, maxExecuteTime, maxExecuteTimeUnit);
            thread.owner = this;
            checker.registerThread((Thread)((Object)thread), thread.info);
            if (useDaemonThread != null && thread.isDaemon() != useDaemonThread.booleanValue()) {
                thread.setDaemon(useDaemonThread);
            }
            return thread;
        };
    }

    @Override
    public Vertx exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public CloseFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    public VertxTracer tracer() {
        return this.tracer;
    }

    @Override
    public void addCloseHook(Closeable hook) {
        this.closeFuture.add(hook);
    }

    @Override
    public void removeCloseHook(Closeable hook) {
        this.closeFuture.remove(hook);
    }

    @Override
    public boolean isVirtualThreadAvailable() {
        return this.virtualThreadExecutor != null;
    }

    private CloseFuture resolveCloseFuture() {
        ContextInternal context = this.getContext();
        return context != null ? context.closeFuture() : this.closeFuture;
    }

    void executeIsolated(Handler<Void> task) {
        if (Thread.currentThread() instanceof VertxThread) {
            ContextInternal prev = this.beginDispatch(null);
            try {
                task.handle(null);
            }
            finally {
                this.endDispatch(prev);
            }
        } else {
            task.handle(null);
        }
    }

    ContextInternal beginDispatch(ContextInternal context) {
        ContextInternal prev;
        Thread thread = Thread.currentThread();
        if (thread instanceof VertxThread) {
            VertxThread vertxThread = (VertxThread)((Object)thread);
            prev = vertxThread.context;
            if (!ContextImpl.DISABLE_TIMINGS) {
                vertxThread.executeStart();
            }
            vertxThread.context = context;
            if (!this.disableTCCL) {
                if (prev == null) {
                    vertxThread.topLevelTCCL = Thread.currentThread().getContextClassLoader();
                }
                if (context != null) {
                    thread.setContextClassLoader(context.classLoader());
                }
            }
        } else {
            prev = this.beginDispatch2(thread, context);
        }
        return prev;
    }

    private ContextInternal beginDispatch2(Thread thread, ContextInternal context) {
        ContextInternal prev;
        ContextDispatch current = nonVertxContextDispatch.get();
        if (current != null) {
            prev = current.context;
        } else {
            current = new ContextDispatch();
            nonVertxContextDispatch.set(current);
            prev = null;
        }
        current.context = context;
        if (!this.disableTCCL) {
            if (prev == null) {
                current.topLevelTCCL = Thread.currentThread().getContextClassLoader();
            }
            thread.setContextClassLoader(context.classLoader());
        }
        return prev;
    }

    void endDispatch(ContextInternal prev) {
        Thread thread = Thread.currentThread();
        if (thread instanceof VertxThread) {
            VertxThread vertxThread = (VertxThread)((Object)thread);
            vertxThread.context = prev;
            if (!this.disableTCCL) {
                ClassLoader tccl;
                if (prev == null) {
                    tccl = vertxThread.topLevelTCCL;
                    vertxThread.topLevelTCCL = null;
                } else {
                    tccl = prev.classLoader();
                }
                Thread.currentThread().setContextClassLoader(tccl);
            }
            if (!ContextImpl.DISABLE_TIMINGS) {
                vertxThread.executeEnd();
            }
        } else {
            this.endDispatch2(prev);
        }
    }

    private void endDispatch2(ContextInternal prev) {
        ClassLoader tccl;
        ContextDispatch current = nonVertxContextDispatch.get();
        if (prev != null) {
            current.context = prev;
            tccl = prev.classLoader();
        } else {
            nonVertxContextDispatch.remove();
            tccl = current.topLevelTCCL;
        }
        if (!this.disableTCCL) {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    @Override
    public <C> C createSharedResource(String resourceKey, String resourceName, CloseFuture closeFuture, Function<CloseFuture, C> supplier) {
        return SharedResourceHolder.createSharedResource(this, resourceKey, resourceName, closeFuture, supplier);
    }

    void duplicate(ContextBase src, ContextBase dst) {
        for (int i = 0; i < this.contextLocals.length; ++i) {
            ContextLocalImpl contextLocal = (ContextLocalImpl)this.contextLocals[i];
            Object local = AccessMode.CONCURRENT.get(src.locals, i);
            if (local != null) {
                local = contextLocal.duplicator.apply(local);
            }
            AccessMode.CONCURRENT.put(dst.locals, i, local);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String version() {
        if (version != null) {
            return version;
        }
        try (InputStream is = VertxImpl.class.getClassLoader().getResourceAsStream("META-INF/vertx/vertx-version.txt");){
            if (is == null) {
                throw new IllegalStateException("Cannot find vertx-version.txt on classpath");
            }
            Scanner scanner = new Scanner(is, StandardCharsets.UTF_8).useDelimiter("\\A");
            try {
                version = scanner.hasNext() ? scanner.next().trim() : "";
                String string = version;
                if (scanner != null) {
                    scanner.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (scanner != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    static {
        cleaner = Cleaner.create();
        nonVertxContextDispatch = new ThreadLocal();
        log = LoggerFactory.getLogger(VertxImpl.class);
        EMPTY_CONTEXT_LOCALS = new Object[0];
        NETTY_IO_RATIO = Integer.getInteger(NETTY_IO_RATIO_PROPERTY_NAME, 50);
        if (System.getProperty("io.netty.leakDetection.level") == null && System.getProperty("io.netty.leakDetectionLevel") == null) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        }
    }

    static class ContextDispatch {
        ContextInternal context;
        ClassLoader topLevelTCCL;

        ContextDispatch() {
        }
    }

    class InternalTimerHandler
    implements Handler<Void>,
    Closeable,
    Runnable {
        private final Handler<Long> handler;
        private final boolean periodic;
        private final long id;
        private final ContextInternal context;
        private final AtomicBoolean disposed = new AtomicBoolean();
        private volatile java.util.concurrent.Future<?> future;

        InternalTimerHandler(long id, Handler<Long> runnable, boolean periodic, ContextInternal context) {
            this.context = context;
            this.id = id;
            this.handler = runnable;
            this.periodic = periodic;
        }

        @Override
        public void run() {
            ContextInternal dispatcher = this.context;
            if (this.periodic) {
                dispatcher = dispatcher.duplicate();
            }
            dispatcher.emit(this);
        }

        @Override
        public void handle(Void v) {
            if (this.periodic) {
                if (!this.disposed.get()) {
                    this.handler.handle(this.id);
                }
            } else if (this.disposed.compareAndSet(false, true)) {
                VertxImpl.this.timeouts.remove(this.id);
                try {
                    this.handler.handle(this.id);
                }
                finally {
                    this.context.removeCloseHook(this);
                }
            }
        }

        private boolean cancel() {
            boolean cancelled = this.tryCancel();
            if (cancelled && this.context.isDeployment()) {
                this.context.removeCloseHook(this);
            }
            return cancelled;
        }

        private boolean tryCancel() {
            if (this.disposed.compareAndSet(false, true)) {
                VertxImpl.this.timeouts.remove(this.id);
                this.future.cancel(false);
                return true;
            }
            return false;
        }

        @Override
        public void close(Promise<Void> completion) {
            this.tryCancel();
            completion.complete();
        }
    }
}

