/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import java.io.File;

public enum SysProps {
    DISABLE_HTTP_HEADERS_VALIDATION("vertx.disableHttpHeadersValidation"),
    DISABLE_WEBSOCKETS("vertx.disableWebsockets"),
    DISABLE_METRICS("vertx.disableMetrics"),
    DISABLE_CONTEXT_TIMINGS("vertx.disableContextTimings"),
    DISABLE_DNS_RESOLVER("vertx.disableDnsResolver"),
    DISABLE_FILE_CACHING("vertx.disableFileCaching"),
    DISABLE_FILE_CP_RESOLVING("vertx.disableFileCPResolving"),
    FILE_CACHE_DIR("vertx.cacheDirBase"){

        @Override
        public String get() {
            Object val = super.get();
            if (val == null) {
                String tmpDir = System.getProperty("java.io.tmpdir", ".");
                String cacheDirBase = "vertx-cache";
                val = tmpDir + File.separator + cacheDirBase;
            }
            return val;
        }
    }
    ,
    LOGGER_DELEGATE_FACTORY_CLASS_NAME("vertx.logger-delegate-factory-class-name");

    public final String name;

    private SysProps(String name) {
        this.name = name;
    }

    public String get() {
        return System.getProperty(this.name);
    }

    public boolean getBoolean() {
        return Boolean.getBoolean(this.name);
    }
}

