/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.impl.Utils;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.Address;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.dns.AddressResolverProvider;
import io.vertx.core.spi.endpoint.EndpointBuilder;
import io.vertx.core.spi.endpoint.EndpointResolver;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostnameResolver
implements io.vertx.core.net.AddressResolver {
    private static final Logger log = LoggerFactory.getLogger(HostnameResolver.class);
    private static final Pattern NDOTS_OPTIONS_PATTERN = HostnameResolver.resolvOption("ndots:[ \\t\\f]*(\\d)+");
    private static final Pattern ROTATE_OPTIONS_PATTERN = HostnameResolver.resolvOption("rotate");
    public static final int DEFAULT_NDOTS_RESOLV_OPTION;
    public static final boolean DEFAULT_ROTATE_RESOLV_OPTION;
    private final Vertx vertx;
    private final AddressResolverGroup<InetSocketAddress> resolverGroup;
    private final AddressResolverProvider provider;

    private static Pattern resolvOption(String regex) {
        return Pattern.compile("^[ \\t\\f]*options[^\n]+" + regex + "(?=$|\\s)", 8);
    }

    public HostnameResolver(Vertx vertx, AddressResolverOptions options) {
        this.provider = AddressResolverProvider.factory(vertx, options);
        this.resolverGroup = this.provider.resolver(options);
        this.vertx = vertx;
    }

    @Override
    public EndpointResolver<?, ?, ?, ?> endpointResolver(Vertx vertx) {
        return new Impl();
    }

    public Future<InetAddress> resolveHostname(String hostname) {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        io.netty.util.concurrent.Future<InetSocketAddress> fut = this.resolveHostname(context.nettyEventLoop(), hostname);
        PromiseInternal promise = context.promise();
        fut.addListener(promise);
        return promise.map(InetSocketAddress::getAddress);
    }

    public io.netty.util.concurrent.Future<InetSocketAddress> resolveHostname(EventLoop eventLoop, String hostname) {
        AddressResolver<InetSocketAddress> resolver = this.getResolver(eventLoop);
        return resolver.resolve((java.net.SocketAddress)InetSocketAddress.createUnresolved(hostname, 0));
    }

    public void resolveHostnameAll(String hostname, Handler<AsyncResult<List<InetSocketAddress>>> resultHandler) {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        io.netty.util.concurrent.Future<List<InetSocketAddress>> fut = this.resolveHostnameAll(context.nettyEventLoop(), hostname);
        PromiseInternal promise = context.promise();
        fut.addListener(promise);
        promise.future().onComplete(resultHandler);
    }

    public io.netty.util.concurrent.Future<List<InetSocketAddress>> resolveHostnameAll(EventLoop eventLoop, String hostname) {
        AddressResolver<InetSocketAddress> resolver = this.getResolver(eventLoop);
        return resolver.resolveAll((java.net.SocketAddress)InetSocketAddress.createUnresolved(hostname, 0));
    }

    public AddressResolver<InetSocketAddress> getResolver(EventLoop eventLoop) {
        return this.resolverGroup.getResolver((EventExecutor)eventLoop);
    }

    AddressResolverGroup<InetSocketAddress> nettyAddressResolverGroup() {
        return this.resolverGroup;
    }

    public Future<Void> close() {
        return this.provider.close();
    }

    public static int parseNdotsOptionFromResolvConf(String s) {
        int ndots = -1;
        Matcher matcher = NDOTS_OPTIONS_PATTERN.matcher(s);
        while (matcher.find()) {
            ndots = Integer.parseInt(matcher.group(1));
        }
        return ndots;
    }

    public static boolean parseRotateOptionFromResolvConf(String s) {
        Matcher matcher = ROTATE_OPTIONS_PATTERN.matcher(s);
        return matcher.find();
    }

    static {
        int ndots = 1;
        boolean rotate = false;
        if (Utils.isLinux()) {
            File f = new File("/etc/resolv.conf");
            try {
                if (f.exists() && f.isFile()) {
                    String conf = Files.readString(f.toPath());
                    int ndotsOption = HostnameResolver.parseNdotsOptionFromResolvConf(conf);
                    if (ndotsOption != -1) {
                        ndots = ndotsOption;
                    }
                    rotate = HostnameResolver.parseRotateOptionFromResolvConf(conf);
                }
            }
            catch (Throwable t) {
                log.debug((Object)"Failed to load options from /etc/resolv/.conf", t);
            }
        }
        DEFAULT_NDOTS_RESOLV_OPTION = ndots;
        DEFAULT_ROTATE_RESOLV_OPTION = rotate;
    }

    class Impl<L>
    implements EndpointResolver<SocketAddress, SocketAddress, L, L> {
        Impl() {
        }

        @Override
        public SocketAddress tryCast(Address address) {
            return address instanceof SocketAddress ? (SocketAddress)address : null;
        }

        @Override
        public SocketAddress addressOf(SocketAddress server) {
            return server;
        }

        @Override
        public Future<L> resolve(SocketAddress address, EndpointBuilder<L, SocketAddress> builder) {
            Promise promise = Promise.promise();
            HostnameResolver.this.resolveHostnameAll(address.host(), ar -> {
                EndpointBuilder builder2 = builder;
                if (ar.succeeded()) {
                    for (InetSocketAddress addr : (List)ar.result()) {
                        builder2 = builder2.addServer(SocketAddress.inetSocketAddress(address.port(), addr.getAddress().getHostAddress()));
                    }
                    promise.complete(builder2.build());
                } else {
                    promise.fail(ar.cause());
                }
            });
            return promise.future();
        }

        @Override
        public L endpoint(L state) {
            return state;
        }

        @Override
        public boolean isValid(L state) {
            return true;
        }

        @Override
        public void dispose(L data) {
        }

        @Override
        public void close() {
        }
    }
}

