/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpClientConnectionInternal;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.impl.Arguments;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Function;

public class HttpClientRequestImpl
extends HttpClientRequestBase
implements HttpClientRequest {
    static final Logger log = LoggerFactory.getLogger(HttpClientRequestImpl.class);
    private final Promise<Void> endPromise = this.context.promise();
    private final Future<Void> endFuture = this.endPromise.future();
    private boolean chunked = false;
    private Handler<Void> continueHandler;
    private Handler<MultiMap> earlyHintsHandler;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Function<HttpClientResponse, Future<HttpClientRequest>> redirectHandler;
    private boolean ended;
    private boolean followRedirects;
    private int maxRedirects;
    private int numberOfRedirections = 0;
    private HeadersMultiMap headers;
    private StreamPriority priority = HttpUtils.DEFAULT_STREAM_PRIORITY;
    private boolean headWritten;
    private boolean isConnect;
    private String traceOperation;

    HttpClientRequestImpl(HttpConnection connection, HttpClientStream stream) {
        super(connection, stream, stream.getContext().promise(), HttpMethod.GET, "/");
        stream.continueHandler(this::handleContinue);
        stream.earlyHintsHandler(this::handleEarlyHints);
        stream.drainHandler(this::handleDrained);
        stream.exceptionHandler(this::handleException);
    }

    public void init(RequestOptions options) {
        MultiMap headers = options.getHeaders();
        if (headers != null) {
            this.headers().setAll(headers);
        }
        HttpClientConnectionInternal conn = this.stream.connection();
        boolean useSSL = conn.isSsl();
        Object requestURI = options.getURI();
        HttpMethod method = options.getMethod();
        String traceOperation = options.getTraceOperation();
        Boolean followRedirects = options.getFollowRedirects();
        long idleTimeout = options.getIdleTimeout();
        ProxyOptions proxyOptions = options.getProxyOptions();
        if (proxyOptions != null && !useSSL && proxyOptions.getType() == ProxyType.HTTP) {
            HostAndPort authority = conn.authority();
            if (!HttpClientImpl.ABS_URI_START_PATTERN.matcher((CharSequence)requestURI).find()) {
                int defaultPort = 80;
                String addPort = authority.port() != -1 && authority.port() != defaultPort ? ":" + authority.port() : "";
                requestURI = "http://" + authority.host() + addPort + (String)requestURI;
            }
            if (proxyOptions.getUsername() != null && proxyOptions.getPassword() != null) {
                this.headers().add("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((proxyOptions.getUsername() + ":" + proxyOptions.getPassword()).getBytes()));
            }
        }
        this.setURI((String)requestURI);
        this.setMethod(method);
        this.traceOperation(traceOperation);
        this.setFollowRedirects(followRedirects == Boolean.TRUE);
        if (idleTimeout > 0L) {
            this.idleTimeout(idleTimeout);
        }
    }

    @Override
    void handleException(Throwable t) {
        t = this.mapException(t);
        super.handleException(t);
        if (this.endPromise.tryFail(t)) {
            Handler<Throwable> handler = this.exceptionHandler();
            if (handler != null) {
                this.context.emit(t, handler);
            } else if (log.isDebugEnabled()) {
                log.error((Object)t.getMessage(), t);
            } else {
                log.error((Object)t.getMessage());
            }
        }
    }

    @Override
    public synchronized HttpClientRequest setFollowRedirects(boolean followRedirects) {
        this.checkEnded();
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    public synchronized boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @Override
    public synchronized HttpClientRequest setMaxRedirects(int maxRedirects) {
        Arguments.require(maxRedirects >= 0, "Max redirects must be >= 0");
        this.checkEnded();
        this.maxRedirects = maxRedirects;
        return this;
    }

    @Override
    public synchronized int getMaxRedirects() {
        return this.maxRedirects;
    }

    @Override
    public int numberOfRedirections() {
        return this.numberOfRedirections;
    }

    @Override
    public synchronized HttpClientRequestImpl setChunked(boolean chunked) {
        this.checkEnded();
        if (this.headWritten) {
            throw new IllegalStateException("Cannot set chunked after data has been written on request");
        }
        if (this.version() != HttpVersion.HTTP_1_0) {
            this.chunked = chunked;
        }
        return this;
    }

    @Override
    public synchronized boolean isChunked() {
        return this.chunked;
    }

    @Override
    public synchronized MultiMap headers() {
        if (this.headers == null) {
            this.headers = HeadersMultiMap.httpHeaders();
        }
        return this.headers;
    }

    @Override
    public synchronized HttpClientRequest putHeader(String name, String value) {
        this.checkEnded();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.checkEnded();
        this.headers().set(name, values);
        return this;
    }

    @Override
    public synchronized HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.checkEnded();
        this.stream.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
        }
        return this.stream.isNotWritable();
    }

    @Override
    public HttpVersion version() {
        return this.stream.version();
    }

    private synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public synchronized HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        if (handler != null) {
            this.checkEnded();
            this.exceptionHandler = handler;
        } else {
            this.exceptionHandler = null;
        }
        return this;
    }

    @Override
    public synchronized HttpClientRequest drainHandler(Handler<Void> handler) {
        if (handler != null) {
            this.checkEnded();
        }
        this.drainHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpClientRequest continueHandler(Handler<Void> handler) {
        if (handler != null) {
            this.checkEnded();
        }
        this.continueHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpClientRequest earlyHintsHandler(@Nullable Handler<MultiMap> handler) {
        if (handler != null) {
            this.checkEnded();
        }
        this.earlyHintsHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpClientRequest redirectHandler(@Nullable Function<HttpClientResponse, Future<HttpClientRequest>> handler) {
        if (handler != null) {
            this.checkEnded();
        }
        this.redirectHandler = handler;
        return this;
    }

    @Override
    public Future<Void> sendHead() {
        this.checkEnded();
        return this.doWrite(null, false, false);
    }

    @Override
    public Future<HttpClientResponse> connect() {
        this.doWrite(null, false, true);
        return this.response();
    }

    @Override
    public synchronized HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.checkEnded();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.checkEnded();
        this.headers().set(name, values);
        return this;
    }

    @Override
    public synchronized HttpClientRequest traceOperation(String op) {
        this.checkEnded();
        this.traceOperation = op;
        return this;
    }

    @Override
    public String traceOperation() {
        return this.traceOperation;
    }

    private void tryComplete() {
        this.endPromise.tryComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeCustomFrame(int type, int flags, Buffer payload) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
        }
        return this.stream.writeFrame(type, flags, ((BufferInternal)payload).getByteBuf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDrained(Void v) {
        Handler<Void> handler;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            handler = this.drainHandler;
            if (handler == null || this.endFuture.isComplete()) {
                return;
            }
        }
        this.context.dispatch(handler);
    }

    private void handleNextRequest(HttpClientRequest next, Promise<HttpClientResponse> handler, long timeoutMs) {
        next.response().onComplete(handler);
        next.exceptionHandler((Handler)this.exceptionHandler());
        this.exceptionHandler((Handler)null);
        next.pushHandler(this.pushHandler());
        next.setFollowRedirects(true);
        next.setMaxRedirects(this.maxRedirects);
        ((HttpClientRequestImpl)next).numberOfRedirections = this.numberOfRedirections + 1;
        this.endFuture.onComplete(ar -> {
            if (ar.succeeded()) {
                if (timeoutMs > 0L) {
                    next.idleTimeout(timeoutMs);
                }
                next.end();
            } else {
                next.reset(0L);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleContinue(Void v) {
        Handler<Void> handler;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            handler = this.continueHandler;
        }
        if (handler != null) {
            handler.handle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEarlyHints(MultiMap headers) {
        Handler<MultiMap> handler;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            handler = this.earlyHintsHandler;
        }
        if (handler != null) {
            handler.handle(headers);
        }
    }

    @Override
    void handleResponse(Promise<HttpClientResponse> promise, HttpClientResponse resp, long timeoutMs) {
        Future<HttpClientRequest> next;
        Function<HttpClientResponse, Future<HttpClientRequest>> handler;
        int statusCode = resp.statusCode();
        if (this.followRedirects && this.numberOfRedirections < this.maxRedirects && statusCode >= 300 && statusCode < 400 && (handler = this.redirectHandler) != null && (next = handler.apply(resp)) != null) {
            resp.end().compose(v -> next, err -> next).onComplete(ar1 -> {
                if (ar1.succeeded()) {
                    this.handleNextRequest((HttpClientRequest)ar1.result(), promise, timeoutMs);
                } else {
                    this.fail(ar1.cause());
                }
            });
            return;
        }
        promise.complete(resp);
    }

    @Override
    public Future<Void> end(String chunk) {
        return this.write(BufferInternal.buffer(chunk).getByteBuf(), true);
    }

    @Override
    public Future<Void> end(String chunk, String enc) {
        Objects.requireNonNull(enc, "no null encoding accepted");
        return this.write(BufferInternal.buffer(chunk, enc).getByteBuf(), true);
    }

    @Override
    public Future<Void> end(Buffer chunk) {
        return this.write(((BufferInternal)chunk).getByteBuf(), true);
    }

    @Override
    public Future<Void> end() {
        return this.write(null, true);
    }

    @Override
    public Future<Void> write(Buffer chunk) {
        ByteBuf buf = ((BufferInternal)chunk).getByteBuf();
        return this.write(buf, false);
    }

    @Override
    public Future<Void> write(String chunk) {
        return this.write(BufferInternal.buffer(chunk).getByteBuf(), false);
    }

    @Override
    public Future<Void> write(String chunk, String enc) {
        Objects.requireNonNull(enc, "no null encoding accepted");
        return this.write(BufferInternal.buffer(chunk, enc).getByteBuf(), false);
    }

    private boolean requiresContentLength() {
        return !this.chunked && (this.headers == null || !this.headers.contains(HttpHeaders.CONTENT_LENGTH)) && !this.isConnect;
    }

    private Future<Void> write(ByteBuf buff, boolean end) {
        if (end) {
            if (buff != null && this.requiresContentLength()) {
                this.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)HttpUtils.positiveLongToString(buff.readableBytes()));
            }
        } else if (this.requiresContentLength()) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
        }
        return this.doWrite(buff, end, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> doWrite(ByteBuf buff, boolean end, boolean connect) {
        Future<Void> future;
        boolean writeEnd;
        boolean writeHead;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (this.ended) {
                return this.context.failedFuture(new IllegalStateException("Request already complete"));
            }
            this.checkResponseHandler();
            if (!this.headWritten) {
                this.headWritten = true;
                this.isConnect = connect;
                writeHead = true;
            } else {
                writeHead = false;
            }
            writeEnd = !this.isConnect && end;
            this.ended = end;
        }
        if (writeHead) {
            HttpMethod method = this.getMethod();
            String uri = this.getURI();
            if (uri.isEmpty()) {
                uri = "/";
            }
            HttpRequestHead head = new HttpRequestHead(method, uri, this.headers, this.authority(), this.absoluteURI(), this.traceOperation);
            future = this.stream.writeHead(head, this.chunked, buff, writeEnd, this.priority, connect);
        } else {
            if (buff == null && !end) {
                throw new IllegalArgumentException();
            }
            future = this.stream.writeBuffer(buff, writeEnd);
        }
        if (end) {
            this.tryComplete();
        }
        return future;
    }

    private void checkEnded() {
        if (this.ended) {
            throw new IllegalStateException("Request already complete");
        }
    }

    private void checkResponseHandler() {
    }

    @Override
    public synchronized HttpClientRequest setStreamPriority(StreamPriority priority) {
        if (this.headWritten) {
            this.stream.updatePriority(priority);
        } else {
            this.priority = priority;
        }
        return this;
    }

    @Override
    public synchronized StreamPriority getStreamPriority() {
        return this.stream.priority();
    }
}

