/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.cluster;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.test.core.TestUtils;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RegistrationInfoSerializationTest {
    private final RegistrationInfo expected;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new RegistrationInfo("foo", -13004L, true)}, {new RegistrationInfo("bar", 13004L, false)});
    }

    public RegistrationInfoSerializationTest(RegistrationInfo expected) {
        this.expected = expected;
    }

    @Test
    public void testSerialization() {
        Buffer padding = TestUtils.randomBuffer(TestUtils.randomShort());
        Buffer buffer = Buffer.buffer();
        buffer.appendBuffer(padding);
        this.expected.writeToBuffer(buffer);
        RegistrationInfo registrationInfo = new RegistrationInfo();
        int pos = registrationInfo.readFromBuffer(padding.length(), buffer);
        Assert.assertEquals((Object)this.expected, (Object)registrationInfo);
        Assert.assertEquals((long)buffer.length(), (long)pos);
    }
}

