/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.FutureInternal;
import io.vertx.core.impl.future.Listener;
import io.vertx.core.impl.future.Transformation;
import java.util.function.Function;

class EventuallyTransformation<T, U>
extends Transformation<U>
implements Listener<T> {
    private final Function<Void, Future<U>> mapper;

    EventuallyTransformation(ContextInternal context, Function<Void, Future<U>> mapper) {
        super(context);
        this.mapper = mapper;
    }

    @Override
    public void onSuccess(T value) {
        FutureInternal future;
        try {
            future = (FutureInternal)this.mapper.apply(null);
        }
        catch (Throwable e) {
            this.tryFail(e);
            return;
        }
        future.addListener(this.newListener());
    }

    @Override
    public void onFailure(Throwable failure) {
        FutureInternal future;
        try {
            future = (FutureInternal)this.mapper.apply(null);
        }
        catch (Throwable e) {
            this.tryFail(e);
            return;
        }
        future.addListener(this.newListener());
    }

    private Listener<U> newListener() {
        return new Listener<U>(){

            @Override
            public void onSuccess(U value) {
                EventuallyTransformation.this.tryComplete(value);
            }

            @Override
            public void onFailure(Throwable failure) {
                EventuallyTransformation.this.tryFail(failure);
            }
        };
    }
}

