/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.http.WebSocket;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.WebSocketImplBase;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.Metrics;

public class WebSocketImpl
extends WebSocketImplBase<WebSocketImpl>
implements WebSocket {
    private final Http1xClientConnection conn;
    private long timerID = -1L;
    private final long closingTimeoutMS;

    public WebSocketImpl(ContextInternal context, Http1xClientConnection conn, boolean supportsContinuation, long closingTimeout, int maxWebSocketFrameSize, int maxWebSocketMessageSize) {
        super(context, conn, supportsContinuation, maxWebSocketFrameSize, maxWebSocketMessageSize);
        this.conn = conn;
        this.closingTimeoutMS = closingTimeout > 0L ? closingTimeout * 1000L : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleConnectionClosed() {
        Http1xClientConnection http1xClientConnection = this.conn;
        synchronized (http1xClientConnection) {
            if (this.timerID != -1L) {
                this.context.owner().cancelTimer(this.timerID);
            }
        }
        super.handleConnectionClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeConnection() {
        if (this.closingTimeoutMS > 0L) {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                this.timerID = this.context.owner().setTimer(this.closingTimeoutMS, id -> {
                    Http1xClientConnection http1xClientConnection = this.conn;
                    synchronized (http1xClientConnection) {
                        this.timerID = -1L;
                    }
                    this.conn.channelHandlerContext().close();
                });
            }
        }
    }

    @Override
    protected void handleClose(boolean graceful) {
        HttpClientMetrics metrics = this.conn.metrics();
        if (Metrics.METRICS_ENABLED && metrics != null) {
            metrics.disconnected(this.getMetric());
            this.setMetric(null);
        }
        super.handleClose(graceful);
    }
}

