/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.DeliveryContext;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.MessageTagExtractor;
import io.vertx.core.eventbus.impl.ReplyHandler;
import io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Iterator;
import java.util.function.BiConsumer;

public class OutboundDeliveryContext<T>
implements DeliveryContext<T>,
Handler<AsyncResult<Void>> {
    public final ContextInternal ctx;
    public final MessageImpl message;
    public final DeliveryOptions options;
    public final ReplyHandler<T> replyHandler;
    private final Promise<Void> writePromise;
    private boolean src;
    Iterator<Handler<DeliveryContext>> iter;
    EventBusImpl bus;
    EventBusMetrics metrics;

    OutboundDeliveryContext(ContextInternal ctx, MessageImpl message, DeliveryOptions options, ReplyHandler<T> replyHandler, Promise<Void> writePromise) {
        this.ctx = ctx;
        this.message = message;
        this.options = options;
        this.replyHandler = replyHandler;
        this.writePromise = writePromise;
    }

    @Override
    public void handle(AsyncResult<Void> event) {
        this.written(event.cause());
    }

    public void written(Throwable failure) {
        Object trace;
        VertxTracer tracer;
        if (this.metrics != null) {
            boolean remote = this.message instanceof ClusteredMessage && ((ClusteredMessage)this.message).isToWire();
            this.metrics.messageSent(this.message.address(), !this.message.send, !remote, remote);
        }
        if ((tracer = this.ctx.tracer()) != null && (trace = this.message.trace) != null && this.src) {
            if (this.replyHandler != null) {
                this.replyHandler.trace = this.message.trace;
            } else {
                tracer.receiveResponse(this.ctx, null, trace, failure, TagExtractor.empty());
            }
        }
        if (failure instanceof ReplyException && this.replyHandler != null) {
            this.replyHandler.fail((ReplyException)failure);
        }
        if (this.writePromise != null) {
            if (failure == null) {
                this.writePromise.complete();
            } else {
                this.writePromise.fail(failure);
            }
        }
    }

    @Override
    public Message<T> message() {
        return this.message;
    }

    @Override
    public void next() {
        block8: {
            if (this.iter.hasNext()) {
                Handler<DeliveryContext> handler = this.iter.next();
                try {
                    if (handler != null) {
                        handler.handle(this);
                        break block8;
                    }
                    this.next();
                }
                catch (Throwable t) {
                    EventBusImpl.log.error("Failure in interceptor", t);
                }
            } else {
                VertxTracer tracer = this.ctx.tracer();
                if (tracer != null) {
                    if (this.message.trace == null) {
                        this.src = true;
                        BiConsumer<String, String> biConsumer = (key, val) -> this.message.headers().set((String)key, (String)val);
                        this.message.trace = tracer.sendRequest(this.ctx, SpanKind.RPC, TracingPolicy.PROPAGATE, this.message, this.message.send ? "send" : "publish", biConsumer, MessageTagExtractor.INSTANCE);
                    } else {
                        tracer.sendResponse(this.ctx, null, this.message.trace, null, TagExtractor.empty());
                    }
                }
                this.bus.sendOrPub(this);
            }
        }
    }

    @Override
    public boolean send() {
        return this.message.isSend();
    }

    @Override
    public Object body() {
        return this.message.sentBody;
    }
}

