/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.logging.Logger;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class CloseHooks {
    private final Logger log;
    private boolean closeHooksRun;
    private Map<Closeable, CloseHooks> closeHooks;

    CloseHooks(Logger log) {
        this.log = log;
        this.closeHooks = new WeakHashMap<Closeable, CloseHooks>();
    }

    public synchronized void add(Closeable hook) {
        if (this.closeHooks == null) {
            throw new IllegalStateException();
        }
        if (hook instanceof CloseFuture) {
            CloseFuture fut = (CloseFuture)hook;
            fut.onComplete(ar -> this.remove(fut));
        }
        this.closeHooks.put(hook, this);
    }

    public synchronized void remove(Closeable hook) {
        if (this.closeHooks != null) {
            this.closeHooks.remove(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(Handler<AsyncResult<Void>> completionHandler) {
        Map<Closeable, CloseHooks> copy;
        CloseHooks closeHooks = this;
        synchronized (closeHooks) {
            if (this.closeHooksRun) {
                throw new IllegalStateException("Close hooks already run");
            }
            this.closeHooksRun = true;
            copy = this.closeHooks;
            this.closeHooks = null;
        }
        ArrayList list = new ArrayList(copy.size());
        copy.keySet().forEach(list::add);
        int num = list.size();
        if (num > 0) {
            AtomicInteger count = new AtomicInteger();
            for (Closeable hook : list) {
                Promise<Void> promise = Promise.promise();
                promise.future().onComplete(ar -> {
                    if (count.incrementAndGet() == num) {
                        completionHandler.handle(Future.succeededFuture());
                    }
                });
                try {
                    hook.close(promise);
                }
                catch (Throwable t) {
                    this.log.warn("Failed to run close hook", t);
                    promise.tryFail(t);
                }
            }
        } else {
            completionHandler.handle(Future.succeededFuture());
        }
    }
}

