/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.http.WebSocket;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.WebSocketImplBase;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.HttpClientMetrics;

public class WebSocketImpl
extends WebSocketImplBase<WebSocketImpl>
implements WebSocket {
    private long timerID = -1L;
    private final long closingTimeoutMS;

    public WebSocketImpl(ContextInternal context, Http1xClientConnection conn, boolean supportsContinuation, long closingTimeout, int maxWebSocketFrameSize, int maxWebSocketMessageSize) {
        super(context, conn, supportsContinuation, maxWebSocketFrameSize, maxWebSocketMessageSize);
        this.closingTimeoutMS = closingTimeout > 0L ? closingTimeout * 1000L : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleClosed() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            HttpClientMetrics metrics;
            if (this.timerID != -1L) {
                this.context.owner().cancelTimer(this.timerID);
            }
            if ((metrics = (HttpClientMetrics)this.conn.metrics()) != null) {
                metrics.disconnected(this.getMetric());
            }
        }
        super.handleClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        if (this.closingTimeoutMS > 0L) {
            Http1xConnectionBase http1xConnectionBase = this.conn;
            synchronized (http1xConnectionBase) {
                this.timerID = this.context.owner().setTimer(this.closingTimeoutMS, id -> {
                    Http1xConnectionBase http1xConnectionBase = this.conn;
                    synchronized (http1xConnectionBase) {
                        this.timerID = -1L;
                    }
                    this.conn.channelHandlerContext().close();
                });
            }
        }
    }
}

