/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.Http1xServerRequest;
import io.vertx.core.http.impl.Http1xServerResponse;
import io.vertx.core.http.impl.HttpServerConnectionHandler;
import io.vertx.core.http.impl.ServerWebSocketImpl;

public class Http1xServerRequestHandler
implements Handler<HttpServerRequest> {
    private final HttpServerConnectionHandler handlers;

    public Http1xServerRequestHandler(HttpServerConnectionHandler handlers) {
        this.handlers = handlers;
    }

    @Override
    public void handle(HttpServerRequest req) {
        if (req.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true) || this.handlers.requestHandler == null) {
            if (this.handlers.server.wsAccept()) {
                this.handle((Http1xServerRequest)req);
            } else {
                req.response().setStatusCode(502).end();
            }
        } else if (req.version() == null) {
            req.response().setStatusCode(501).end();
            req.response().close();
        } else {
            this.handlers.requestHandler.handle(req);
        }
    }

    @Override
    private void handle(Http1xServerRequest req) {
        Buffer body = Buffer.buffer();
        boolean[] failed = new boolean[1];
        req.handler(buff -> {
            if (!failed[0]) {
                body.appendBuffer((Buffer)buff);
                if (body.length() > 8192) {
                    failed[0] = true;
                    Http1xServerResponse resp = req.response();
                    resp.setStatusCode(413).end();
                    resp.close();
                }
            }
        });
        req.endHandler(v -> {
            if (!failed[0]) {
                this.handle(req, body);
            }
        });
    }

    private void handle(Http1xServerRequest req, Buffer body) {
        HttpRequest nettyReq = req.nettyRequest();
        nettyReq = new DefaultFullHttpRequest(nettyReq.protocolVersion(), nettyReq.method(), nettyReq.uri(), body.getByteBuf(), nettyReq.headers(), (io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE);
        req.setRequest(nettyReq);
        if (this.handlers.wsHandler != null) {
            ServerWebSocketImpl ws = ((Http1xServerConnection)req.connection()).createWebSocket(req);
            if (ws == null) {
                return;
            }
            this.handlers.wsHandler.handle(ws);
            ws.tryHandshake(101);
        } else {
            this.handlers.requestHandler.handle(req);
        }
    }
}

