/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;

class SucceededFuture<T>
implements Future<T> {
    private final ContextInternal context;
    private final T result;

    SucceededFuture(ContextInternal context, T result) {
        this.context = context;
        this.result = result;
    }

    @Override
    public ContextInternal context() {
        return this.context;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public Future<T> onComplete(Handler<AsyncResult<T>> handler) {
        if (this.context != null) {
            this.context.dispatch(this, handler);
        } else {
            handler.handle(this);
        }
        return this;
    }

    @Override
    public T result() {
        return this.result;
    }

    @Override
    public Throwable cause() {
        return null;
    }

    @Override
    public boolean succeeded() {
        return true;
    }

    @Override
    public boolean failed() {
        return false;
    }

    public String toString() {
        return "Future{result=" + this.result + "}";
    }
}

