/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.JsonObject;
import java.util.Map;

public class RequestOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, RequestOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "absoluteURI": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAbsoluteURI((String)member.getValue());
                    break;
                }
                case "authority": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAuthority((String)member.getValue());
                    break;
                }
                case "followRedirects": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setFollowRedirects((Boolean)member.getValue());
                    break;
                }
                case "headers": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addHeader((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    break;
                }
                case "host": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHost((String)member.getValue());
                    break;
                }
                case "method": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMethod(new HttpMethod((String)member.getValue()));
                    break;
                }
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "ssl": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setSsl((Boolean)member.getValue());
                    break;
                }
                case "timeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "uri": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setURI((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(RequestOptions obj, JsonObject json) {
        RequestOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(RequestOptions obj, Map<String, Object> json) {
        if (obj.getAuthority() != null) {
            json.put("authority", obj.getAuthority());
        }
        if (obj.getFollowRedirects() != null) {
            json.put("followRedirects", obj.getFollowRedirects());
        }
        if (obj.getHost() != null) {
            json.put("host", obj.getHost());
        }
        if (obj.getMethod() != null) {
            json.put("method", obj.getMethod().toJson());
        }
        if (obj.getPort() != null) {
            json.put("port", obj.getPort());
        }
        if (obj.isSsl() != null) {
            json.put("ssl", obj.isSsl());
        }
        json.put("timeout", obj.getTimeout());
        if (obj.getURI() != null) {
            json.put("uri", obj.getURI());
        }
    }
}

