/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.CloseHooks;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.spi.tracing.VertxTracer;

public class EventLoopContext
extends ContextImpl {
    EventLoopContext(VertxInternal vertx, VertxTracer<?, ?> tracer, EventLoop eventLoop, WorkerPool internalBlockingPool, WorkerPool workerPool, Deployment deployment, CloseHooks closeHooks, ClassLoader tccl) {
        super(vertx, tracer, eventLoop, internalBlockingPool, workerPool, deployment, closeHooks, tccl);
    }

    @Override
    <T> void execute(T argument, Handler<T> task) {
        this.nettyEventLoop().execute(() -> this.emit(argument, task));
    }

    @Override
    public void execute(Runnable task) {
        this.nettyEventLoop().execute(() -> this.emit(task));
    }

    @Override
    public <T> void schedule(T argument, Handler<T> task) {
        EventLoop eventLoop = this.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            task.handle(argument);
        } else {
            eventLoop.execute(() -> task.handle(argument));
        }
    }

    @Override
    public boolean isEventLoopContext() {
        return true;
    }

    @Override
    public ContextInternal duplicate() {
        return new Duplicated(this);
    }

    static class Duplicated
    extends ContextImpl.Duplicated<EventLoopContext> {
        private TaskQueue orderedTasks;

        Duplicated(EventLoopContext delegate) {
            super(delegate);
        }

        @Override
        public CloseHooks closeHooks() {
            return ((EventLoopContext)this.delegate).closeHooks();
        }

        @Override
        <T> void execute(T argument, Handler<T> task) {
            this.nettyEventLoop().execute(() -> this.emit(argument, task));
        }

        @Override
        public void execute(Runnable task) {
            this.nettyEventLoop().execute(() -> this.emit(task));
        }

        @Override
        public final <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action) {
            return ContextImpl.executeBlocking(this, action, ((EventLoopContext)this.delegate).internalBlockingPool, ((EventLoopContext)this.delegate).internalOrderedTasks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> Future<@Nullable T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
            TaskQueue queue;
            if (ordered) {
                queue = null;
            } else {
                Duplicated duplicated = this;
                synchronized (duplicated) {
                    if (this.orderedTasks == null) {
                        this.orderedTasks = new TaskQueue();
                    }
                    queue = this.orderedTasks;
                }
            }
            return ContextImpl.executeBlocking(this, blockingCodeHandler, ((EventLoopContext)this.delegate).workerPool, queue);
        }

        @Override
        public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue) {
            return ContextImpl.executeBlocking(this, blockingCodeHandler, ((EventLoopContext)this.delegate).workerPool, queue);
        }

        @Override
        public <T> void schedule(T argument, Handler<T> task) {
            ((EventLoopContext)this.delegate).schedule(argument, task);
        }

        @Override
        public boolean isEventLoopContext() {
            return true;
        }

        @Override
        public ContextInternal duplicate() {
            return new Duplicated((EventLoopContext)this.delegate);
        }
    }
}

