/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.streams.impl.InboundBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

abstract class VertxHttp2Stream<C extends Http2ConnectionBase> {
    private static final MultiMap EMPTY = new Http2HeadersAdaptor((Http2Headers)EmptyHttp2Headers.INSTANCE);
    protected final C conn;
    protected final VertxInternal vertx;
    protected final ContextInternal context;
    protected Http2Stream stream;
    private long bytesRead;
    private long bytesWritten;
    private StreamPriority priority;
    private final InboundBuffer<Object> pending;
    private boolean writable;

    VertxHttp2Stream(C conn, ContextInternal context) {
        this.conn = conn;
        this.vertx = ((Http2ConnectionBase)conn).vertx();
        this.context = context;
        this.pending = new InboundBuffer(context, 5L);
        this.priority = HttpUtils.DEFAULT_STREAM_PRIORITY;
        this.pending.handler(item -> {
            if (item instanceof MultiMap) {
                conn.reportBytesRead(this.bytesRead);
                this.handleEnd((MultiMap)item);
            } else {
                Buffer data = (Buffer)item;
                int len = data.length();
                conn.getContext().dispatch(null, v -> conn.consumeCredits(this.stream, len));
                this.bytesRead += (long)len;
                this.handleData(data);
            }
        });
        this.pending.exceptionHandler(context::reportException);
        this.pending.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(Http2Stream stream) {
        VertxHttp2Stream vertxHttp2Stream = this;
        synchronized (vertxHttp2Stream) {
            this.stream = stream;
            this.writable = ((Http2ConnectionBase)this.conn).handler.encoder().flowController().isWritable(stream);
        }
        stream.setProperty(((Http2ConnectionBase)this.conn).streamKey, (Object)this);
    }

    void onClose() {
        ((ConnectionBase)this.conn).reportBytesWritten(this.bytesWritten);
        this.context.schedule(v -> this.handleClose());
    }

    void onError(Throwable cause) {
        this.context.dispatch(cause, this::handleException);
    }

    void onReset(long code) {
        this.context.dispatch(code, this::handleReset);
    }

    void onPriorityChange(StreamPriority newPriority) {
        this.context.dispatch(newPriority, priority -> {
            if (!this.priority.equals(priority)) {
                this.priority = priority;
                this.handlePriorityChange((StreamPriority)priority);
            }
        });
    }

    void onCustomFrame(HttpFrame frame) {
        this.context.dispatch(frame, this::handleCustomFrame);
    }

    void onHeaders(Http2Headers headers, StreamPriority streamPriority) {
    }

    void onData(Buffer data) {
        this.context.dispatch(data, this.pending::write);
    }

    void onWritabilityChanged() {
        this.context.dispatch(null, v -> {
            boolean w;
            VertxHttp2Stream vertxHttp2Stream = this;
            synchronized (vertxHttp2Stream) {
                w = this.writable = !this.writable;
            }
            this.handleWritabilityChanged(w);
        });
    }

    void onEnd() {
        this.onEnd(EMPTY);
    }

    void onEnd(MultiMap trailers) {
        this.context.dispatch(trailers, this.pending::write);
    }

    public int id() {
        return this.stream.id();
    }

    long bytesWritten() {
        return this.bytesWritten;
    }

    long bytesRead() {
        return this.bytesRead;
    }

    public void doPause() {
        this.pending.pause();
    }

    public void doFetch(long amount) {
        this.pending.fetch(amount);
    }

    public synchronized boolean isNotWritable() {
        return !this.writable;
    }

    public final void writeFrame(int type, int flags, ByteBuf payload) {
        EventLoop eventLoop = ((ConnectionBase)this.conn).getContext().nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            this.doWriteFrame(type, flags, payload);
        } else {
            eventLoop.execute(() -> this.doWriteFrame(type, flags, payload));
        }
    }

    private void doWriteFrame(int type, int flags, ByteBuf payload) {
        ((Http2ConnectionBase)this.conn).handler.writeFrame(this.stream, (byte)type, (short)flags, payload);
    }

    final void writeHeaders(Http2Headers headers, boolean end, Handler<AsyncResult<Void>> handler) {
        EventLoop eventLoop = ((ConnectionBase)this.conn).getContext().nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            this.doWriteHeaders(headers, end, handler);
        } else {
            eventLoop.execute(() -> this.doWriteHeaders(headers, end, handler));
        }
    }

    void doWriteHeaders(Http2Headers headers, boolean end, Handler<AsyncResult<Void>> handler) {
        PromiseInternal<Void> promise = handler == null ? null : this.context.promise(handler);
        ((Http2ConnectionBase)this.conn).handler.writeHeaders(this.stream, headers, end, this.priority.getDependency(), this.priority.getWeight(), this.priority.isExclusive(), promise);
    }

    void flush() {
        ((Http2ConnectionBase)this.conn).flush(this.stream);
    }

    private void writePriorityFrame(StreamPriority priority) {
        ((Http2ConnectionBase)this.conn).handler.writePriority(this.stream, priority.getDependency(), priority.getWeight(), priority.isExclusive());
    }

    final void writeData(ByteBuf chunk, boolean end, Handler<AsyncResult<Void>> handler) {
        ContextInternal ctx = ((ConnectionBase)this.conn).getContext();
        EventLoop eventLoop = ctx.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            this.doWriteData(chunk, end, handler);
        } else {
            eventLoop.execute(() -> this.doWriteData(chunk, end, handler));
        }
    }

    void doWriteData(ByteBuf chunk, boolean end, Handler<AsyncResult<Void>> handler) {
        this.bytesWritten += (long)chunk.readableBytes();
        PromiseInternal<Void> promise = handler == null ? null : this.context.promise(handler);
        ((Http2ConnectionBase)this.conn).handler.writeData(this.stream, chunk, end, promise);
    }

    final void writeReset(long code) {
        EventLoop eventLoop = ((ConnectionBase)this.conn).getContext().nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            this.doWriteReset(code);
        } else {
            eventLoop.execute(() -> this.doWriteReset(code));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteReset(long code) {
        int streamId;
        VertxHttp2Stream vertxHttp2Stream = this;
        synchronized (vertxHttp2Stream) {
            streamId = this.stream != null ? this.stream.id() : -1;
        }
        if (streamId != -1) {
            ((Http2ConnectionBase)this.conn).handler.writeReset(streamId, code);
        } else {
            this.handleReset(code);
        }
    }

    void handleWritabilityChanged(boolean writable) {
    }

    void handleData(Buffer buf) {
    }

    void handleCustomFrame(HttpFrame frame) {
    }

    void handleEnd(MultiMap trailers) {
    }

    void handleReset(long errorCode) {
    }

    void handleException(Throwable cause) {
    }

    void handleClose() {
    }

    synchronized void priority(StreamPriority streamPriority) {
        this.priority = streamPriority;
    }

    synchronized StreamPriority priority() {
        return this.priority;
    }

    synchronized void updatePriority(StreamPriority priority) {
        if (!this.priority.equals(priority)) {
            this.priority = priority;
            if (this.stream != null) {
                this.writePriorityFrame(priority);
            }
        }
    }

    void handlePriorityChange(StreamPriority newPriority) {
    }

    void resolveFile(String filename, long offset, long length, Handler<AsyncResult<AsyncFile>> resultHandler) {
        File file_ = this.vertx.resolveFile(filename);
        if (!file_.exists()) {
            resultHandler.handle(Future.failedFuture(new FileNotFoundException()));
            return;
        }
        try (RandomAccessFile raf = new RandomAccessFile(file_, "r");){
            FileSystem fs = ((Http2ConnectionBase)this.conn).vertx().fileSystem();
            fs.open(filename, new OpenOptions().setCreate(false).setWrite(false), ar -> {
                if (ar.succeeded()) {
                    AsyncFile file = (AsyncFile)ar.result();
                    long contentLength = Math.min(length, file_.length() - offset);
                    file.setReadPos(offset);
                    file.setReadLength(contentLength);
                }
                resultHandler.handle((AsyncResult<AsyncFile>)ar);
            });
        }
        catch (IOException e) {
            resultHandler.handle(Future.failedFuture(e));
        }
    }
}

