/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.HttpServerConnection;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.http.impl.WebSocketRequestHandler;
import io.vertx.core.impl.ContextInternal;
import java.util.ArrayList;

public class HttpServerConnectionHandler
implements Handler<HttpServerConnection> {
    final HttpServerImpl server;
    final Handler<HttpServerRequest> requestHandler;
    final Handler<ServerWebSocket> wsHandler;
    final Handler<HttpConnection> connectionHandler;
    final Handler<Throwable> exceptionHandler;

    public HttpServerConnectionHandler(HttpServerImpl server, Handler<HttpServerRequest> requestHandler, Handler<ServerWebSocket> wsHandler, Handler<HttpConnection> connectionHandler, Handler<Throwable> exceptionHandler) {
        this.server = server;
        this.requestHandler = requestHandler;
        this.wsHandler = wsHandler;
        this.connectionHandler = connectionHandler;
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServerConnection conn) {
        WebSocketRequestHandler requestHandler = this.requestHandler;
        if (!HttpServerImpl.DISABLE_WEBSOCKETS && conn instanceof Http1xServerConnection) {
            requestHandler = new WebSocketRequestHandler(this);
            Http1xServerConnection c = (Http1xServerConnection)conn;
            this.initializeWebSocketExtensions(c.channelHandlerContext().pipeline());
        }
        conn.exceptionHandler(this.exceptionHandler);
        conn.handler(requestHandler);
        if (this.connectionHandler != null) {
            ContextInternal ctx = conn.getContext();
            ContextInternal prev = ctx.emitBegin();
            try {
                this.connectionHandler.handle(conn);
            }
            catch (Exception e) {
                ctx.reportException(e);
            }
            finally {
                ctx.emitEnd(prev);
            }
        }
    }

    private void initializeWebSocketExtensions(ChannelPipeline pipeline) {
        ArrayList<Object> extensionHandshakers = new ArrayList<Object>();
        if (this.server.options.getPerFrameWebSocketCompressionSupported()) {
            extensionHandshakers.add(new DeflateFrameServerExtensionHandshaker(this.server.options.getWebSocketCompressionLevel()));
        }
        if (this.server.options.getPerMessageWebSocketCompressionSupported()) {
            extensionHandshakers.add(new PerMessageDeflateServerExtensionHandshaker(this.server.options.getWebSocketCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, this.server.options.getWebSocketAllowServerNoContext(), this.server.options.getWebSocketPreferredClientNoContext()));
        }
        if (!extensionHandshakers.isEmpty()) {
            WebSocketServerExtensionHandler extensionHandler = new WebSocketServerExtensionHandler(extensionHandshakers.toArray(new WebSocketServerExtensionHandshaker[extensionHandshakers.size()]));
            pipeline.addBefore("handler", "webSocketExtensionHandler", (ChannelHandler)extensionHandler);
        }
    }
}

