/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.NoStackTraceTimeoutException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.net.SocketAddress;

public abstract class HttpClientRequestBase
implements HttpClientRequest {
    protected final HttpClientImpl client;
    protected final ContextInternal context;
    protected final HttpMethod method;
    protected final String uri;
    protected final String host;
    protected final int port;
    protected final SocketAddress server;
    protected final boolean ssl;
    private String path;
    private String query;
    private final PromiseInternal<HttpClientResponse> responsePromise;
    private long currentTimeoutTimerId = -1L;
    private long currentTimeoutMs;
    private long lastDataReceived;

    HttpClientRequestBase(HttpClientImpl client, PromiseInternal<HttpClientResponse> responsePromise, boolean ssl, HttpMethod method, SocketAddress server, String host, int port, String uri) {
        this.client = client;
        this.responsePromise = responsePromise;
        this.context = (ContextInternal)responsePromise.future().context();
        this.uri = uri;
        this.method = method;
        this.server = server;
        this.host = host;
        this.port = port;
        this.ssl = ssl;
    }

    protected String authority() {
        if (this.port == 80 && !this.ssl || this.port == 443 && this.ssl) {
            return this.host;
        }
        return this.host + ':' + this.port;
    }

    @Override
    public String absoluteURI() {
        return (this.ssl ? "https://" : "http://") + this.authority() + this.uri;
    }

    @Override
    public String query() {
        if (this.query == null) {
            this.query = HttpUtils.parseQuery(this.uri);
        }
        return this.query;
    }

    @Override
    public String path() {
        if (this.path == null) {
            this.path = this.uri.length() > 0 ? HttpUtils.parsePath(this.uri) : "";
        }
        return this.path;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    public String host() {
        return this.server.host();
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public synchronized HttpClientRequest setTimeout(long timeoutMs) {
        this.cancelTimeout();
        this.currentTimeoutMs = timeoutMs;
        this.currentTimeoutTimerId = this.client.getVertx().setTimer(timeoutMs, id -> this.handleTimeout(timeoutMs));
        return this;
    }

    void handleException(Throwable t) {
        this.fail(t);
    }

    void fail(Throwable t) {
        this.cancelTimeout();
        this.responsePromise.tryFail(t);
        HttpClientResponseImpl response = (HttpClientResponseImpl)this.responsePromise.future().result();
        if (response != null) {
            response.handleException(t);
        }
    }

    void handleResponse(HttpClientResponse resp) {
        this.handleResponse(this.responsePromise, resp, this.cancelTimeout());
    }

    abstract void handleResponse(Promise<HttpClientResponse> var1, HttpClientResponse var2, long var3);

    private synchronized long cancelTimeout() {
        long ret = this.currentTimeoutTimerId;
        if (ret != -1L) {
            this.client.getVertx().cancelTimer(this.currentTimeoutTimerId);
            this.currentTimeoutTimerId = -1L;
            ret = this.currentTimeoutMs;
            this.currentTimeoutMs = 0L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeout(long timeoutMs) {
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            long now;
            long timeSinceLastData;
            if (this.lastDataReceived > 0L && (timeSinceLastData = (now = System.currentTimeMillis()) - this.lastDataReceived) < timeoutMs) {
                this.lastDataReceived = 0L;
                this.setTimeout(timeoutMs - timeSinceLastData);
                return;
            }
        }
        String msg = "The timeout period of " + timeoutMs + "ms has been exceeded while executing " + this.method + " " + this.uri + " for server " + this.server;
        this.reset(new NoStackTraceTimeoutException(msg));
    }

    synchronized void dataReceived() {
        if (this.currentTimeoutTimerId != -1L) {
            this.lastDataReceived = System.currentTimeMillis();
        }
    }

    @Override
    public boolean reset(long code) {
        return this.reset(new StreamResetException(code));
    }

    @Override
    public boolean reset(long code, Throwable cause) {
        return this.reset(new StreamResetException(code, cause));
    }

    abstract boolean reset(Throwable var1);

    @Override
    public HttpClientRequest onComplete(Handler<AsyncResult<HttpClientResponse>> handler) {
        this.responsePromise.future().onComplete(handler);
        return this;
    }

    @Override
    public boolean isComplete() {
        return this.responsePromise.future().isComplete();
    }

    @Override
    public HttpClientResponse result() {
        return (HttpClientResponse)this.responsePromise.future().result();
    }

    @Override
    public Throwable cause() {
        return this.responsePromise.future().cause();
    }

    @Override
    public boolean succeeded() {
        return this.responsePromise.future().succeeded();
    }

    @Override
    public boolean failed() {
        return this.responsePromise.future().failed();
    }
}

