/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.Http1xServerRequest;
import io.vertx.core.http.impl.HttpChunkContentCompressor;
import io.vertx.core.http.impl.HttpServerConnection;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.ServerWebSocketImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.HashMap;

public class Http1xServerConnection
extends Http1xConnectionBase<ServerWebSocketImpl>
implements HttpServerConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerConnection.class);
    private final String serverOrigin;
    private final SSLHelper sslHelper;
    private boolean requestFailed;
    private long bytesRead;
    private Http1xServerRequest requestInProgress;
    private Http1xServerRequest responseInProgress;
    private boolean channelPaused;
    private Handler<HttpServerRequest> requestHandler;
    final HttpServerMetrics metrics;
    final boolean handle100ContinueAutomatically;
    final HttpServerOptions options;

    public Http1xServerConnection(VertxInternal vertx, SSLHelper sslHelper, HttpServerOptions options, ChannelHandlerContext channel, ContextInternal context, String serverOrigin, HttpServerMetrics metrics) {
        super(vertx, channel, context);
        this.serverOrigin = serverOrigin;
        this.options = options;
        this.sslHelper = sslHelper;
        this.metrics = metrics;
        this.handle100ContinueAutomatically = options.isHandle100ContinueAutomatically();
    }

    @Override
    public HttpServerConnection handler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
        return this;
    }

    @Override
    public HttpServerMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void handleMessage(Object msg) {
        if (msg instanceof HttpRequest) {
            Http1xServerRequest req;
            DefaultHttpRequest request = (DefaultHttpRequest)msg;
            if (request.decoderResult() != DecoderResult.SUCCESS) {
                this.handleError((HttpObject)request);
                return;
            }
            this.requestInProgress = req = new Http1xServerRequest(this, (HttpRequest)request);
            if (this.responseInProgress != null) {
                this.responseInProgress.enqueue(req);
                req.pause();
                return;
            }
            this.responseInProgress = this.requestInProgress;
            if (Metrics.METRICS_ENABLED) {
                this.reportRequestBegin(req);
            }
            req.context.dispatch(req, r -> {
                req.handleBegin();
                this.requestHandler.handle((HttpServerRequest)r);
            });
        } else if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            this.onEnd();
        } else if (msg instanceof HttpContent) {
            this.onContent(msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWsFrame((WebSocketFrame)msg);
        }
    }

    private void reportRequestBegin(Http1xServerRequest request) {
        VertxTracer tracer;
        if (this.metrics != null) {
            request.metric = this.metrics.requestBegin(this.metric(), request);
        }
        if ((tracer = this.context.tracer()) != null) {
            request.trace = tracer.receiveRequest(request.context, request, request.method().name(), request.headers(), HttpUtils.SERVER_REQUEST_TAG_EXTRACTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onContent(Object msg) {
        Http1xServerRequest request;
        HttpContent content = (HttpContent)msg;
        if (content.decoderResult() != DecoderResult.SUCCESS) {
            this.handleError((HttpObject)content);
            return;
        }
        Buffer buffer = Buffer.buffer(VertxHandler.safeBuffer(content.content(), this.chctx.alloc()));
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            if (Metrics.METRICS_ENABLED) {
                this.reportBytesRead(buffer);
            }
            request = this.requestInProgress;
        }
        request.context.schedule(buffer, request::handleContent);
        if (content instanceof LastHttpContent) {
            this.onEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEnd() {
        Http1xServerRequest request;
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            if (Metrics.METRICS_ENABLED) {
                this.reportRequestComplete();
            }
            request = this.requestInProgress;
            this.requestInProgress = null;
        }
        request.context.schedule(request, Http1xServerRequest::handleEnd);
    }

    void responseComplete() {
        EventLoop eventLoop = this.context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            if (Metrics.METRICS_ENABLED) {
                this.reportResponseComplete();
            }
            Http1xServerRequest request = this.responseInProgress;
            this.responseInProgress = null;
            Http1xServerRequest next = request.next();
            if (next != null) {
                this.handleNext(next);
            }
        } else {
            eventLoop.execute(this::responseComplete);
        }
    }

    private void handleNext(Http1xServerRequest next) {
        this.responseInProgress = next;
        this.context.dispatch(next, next_ -> {
            next_.handleBegin();
            next_.resume();
            this.requestHandler.handle((HttpServerRequest)next_);
        });
    }

    @Override
    public void doPause() {
        if (!this.channelPaused) {
            this.channelPaused = true;
            super.doPause();
        }
    }

    @Override
    public void doResume() {
        if (this.channelPaused) {
            this.channelPaused = false;
            super.doResume();
        }
    }

    private void reportBytesRead(Buffer buffer) {
        if (this.metrics != null) {
            this.bytesRead += (long)buffer.length();
        }
    }

    private void reportRequestComplete() {
        if (this.metrics != null) {
            this.reportBytesRead(this.bytesRead);
            this.bytesRead = 0L;
        }
    }

    private void reportResponseComplete() {
        VertxTracer tracer;
        if (this.metrics != null) {
            this.reportBytesWritten(this.bytesWritten);
            this.bytesWritten = 0L;
            if (this.requestFailed) {
                this.metrics.requestReset(this.responseInProgress.metric());
                this.requestFailed = false;
            } else {
                this.metrics.responseEnd(this.responseInProgress.metric(), this.responseInProgress.response());
            }
        }
        if ((tracer = this.context.tracer()) != null) {
            tracer.sendResponse(this.responseInProgress.context, this.responseInProgress.response(), this.responseInProgress.trace(), null, HttpUtils.SERVER_RESPONSE_TAG_EXTRACTOR);
        }
    }

    String getServerOrigin() {
        return this.serverOrigin;
    }

    Vertx vertx() {
        return this.vertx;
    }

    ServerWebSocketImpl createWebSocket(Http1xServerRequest request) {
        if (this.webSocket != null) {
            return (ServerWebSocketImpl)this.webSocket;
        }
        if (!(request.nettyRequest() instanceof FullHttpRequest)) {
            throw new IllegalStateException();
        }
        WebSocketServerHandshaker handshaker = this.createHandshaker(request);
        if (handshaker == null) {
            return null;
        }
        this.webSocket = new ServerWebSocketImpl(this.vertx.getOrCreateContext(), this, handshaker.version() != WebSocketVersion.V00, request, handshaker, this.options.getMaxWebSocketFrameSize(), this.options.getMaxWebSocketMessageSize());
        if (Metrics.METRICS_ENABLED && this.metrics != null) {
            ((ServerWebSocketImpl)this.webSocket).setMetric(this.metrics.connected(this.metric(), request.metric(), (ServerWebSocket)((Object)this.webSocket)));
        }
        return (ServerWebSocketImpl)this.webSocket;
    }

    private WebSocketServerHandshaker createHandshaker(Http1xServerRequest request) {
        WebSocketServerHandshakerFactory factory;
        WebSocketServerHandshaker shake;
        String wsURL;
        Channel ch = this.channel();
        String connectionHeader = request.getHeader(HttpHeaders.CONNECTION);
        if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("\"Connection\" header must be \"Upgrade\".");
            return null;
        }
        if (request.method() != HttpMethod.GET) {
            request.response().setStatusCode(HttpResponseStatus.METHOD_NOT_ALLOWED.code()).end();
            return null;
        }
        try {
            wsURL = HttpUtils.getWebSocketLocation(request, this.isSsl());
        }
        catch (Exception e) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Invalid request URI");
            return null;
        }
        String subp = null;
        if (this.options.getWebSocketSubProtocols() != null) {
            subp = String.join((CharSequence)",", this.options.getWebSocketSubProtocols());
        }
        if ((shake = (factory = new WebSocketServerHandshakerFactory(wsURL, subp, this.options.getPerMessageWebSocketCompressionSupported() || this.options.getPerFrameWebSocketCompressionSupported(), this.options.getMaxWebSocketFrameSize(), this.options.isAcceptUnmaskedFrames())).newHandshaker(request.nettyRequest())) == null) {
            request.response().putHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (CharSequence)WebSocketVersion.V13.toHttpHeaderValue()).setStatusCode(HttpResponseStatus.UPGRADE_REQUIRED.code()).end();
        }
        return shake;
    }

    NetSocket createNetSocket() {
        final HashMap<Channel, 1> connectionMap = new HashMap<Channel, 1>(1);
        NetSocketImpl socket = new NetSocketImpl(this.vertx, this.chctx, this.context, this.sslHelper, this.metrics){

            @Override
            protected void handleClosed() {
                if (Http1xServerConnection.this.metrics != null) {
                    Http1xServerConnection.this.metrics.responseEnd(Http1xServerConnection.this.responseInProgress.metric(), Http1xServerConnection.this.responseInProgress.response());
                }
                connectionMap.remove(this.chctx.channel());
                super.handleClosed();
            }

            @Override
            public synchronized void handleMessage(Object msg) {
                if (msg instanceof HttpContent) {
                    ReferenceCountUtil.release((Object)msg);
                    return;
                }
                super.handleMessage(msg);
            }
        };
        socket.metric(this.metric());
        connectionMap.put(this.chctx.channel(), socket);
        this.flush();
        ChannelPipeline pipeline = this.chctx.pipeline();
        ChannelHandler compressor = pipeline.get(HttpChunkContentCompressor.class);
        if (compressor != null) {
            pipeline.remove(compressor);
        }
        pipeline.remove("httpDecoder");
        if (pipeline.get("chunkedWriter") != null) {
            pipeline.remove("chunkedWriter");
        }
        this.chctx.pipeline().replace("handler", "handler", VertxHandler.create(ctx -> socket));
        this.chctx.pipeline().remove("httpEncoder");
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInterestedOpsChanged() {
        Handler<Boolean> handler;
        ContextInternal context;
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            if (this.responseInProgress != null) {
                context = this.responseInProgress.context;
                handler = this.responseInProgress.response()::handleWritabilityChanged;
            } else if (this.webSocket != null) {
                context = ((ServerWebSocketImpl)this.webSocket).context;
                handler = ((ServerWebSocketImpl)this.webSocket)::handleWritabilityChanged;
            } else {
                return;
            }
        }
        boolean writable = !this.isNotWritable();
        context.schedule(writable, handler);
    }

    void write100Continue() {
        this.chctx.writeAndFlush((Object)new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClosed() {
        Http1xServerRequest responseInProgress;
        Http1xServerRequest requestInProgress;
        ServerWebSocketImpl ws;
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            ws = (ServerWebSocketImpl)this.webSocket;
            requestInProgress = this.requestInProgress;
            responseInProgress = this.responseInProgress;
            if (Metrics.METRICS_ENABLED && this.metrics != null && ws != null) {
                this.metrics.disconnected(ws.getMetric());
                ws.setMetric(null);
            }
        }
        if (requestInProgress != null) {
            requestInProgress.context.schedule(v -> requestInProgress.handleException(CLOSED_EXCEPTION));
        }
        if (responseInProgress != null && responseInProgress != requestInProgress) {
            responseInProgress.context.schedule(v -> responseInProgress.handleException(CLOSED_EXCEPTION));
        }
        if (ws != null) {
            ws.context.schedule(v -> ws.handleClosed());
        }
        super.handleClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleException(Throwable t) {
        Http1xServerRequest responseInProgress;
        Http1xServerRequest requestInProgress;
        ServerWebSocketImpl ws;
        super.handleException(t);
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            ws = (ServerWebSocketImpl)this.webSocket;
            requestInProgress = this.requestInProgress;
            responseInProgress = this.responseInProgress;
            if (Metrics.METRICS_ENABLED && this.metrics != null) {
                this.requestFailed = true;
            }
        }
        if (requestInProgress != null) {
            requestInProgress.handleException(t);
        }
        if (responseInProgress != null && responseInProgress != requestInProgress) {
            responseInProgress.handleException(t);
        }
        if (ws != null) {
            ws.context.schedule(v -> ws.handleException(t));
        }
    }

    @Override
    protected boolean supportsFileRegion() {
        return super.supportsFileRegion() && this.chctx.pipeline().get(HttpChunkContentCompressor.class) == null;
    }

    private void handleError(HttpObject obj) {
        DecoderResult result = obj.decoderResult();
        Throwable cause = result.cause();
        if (cause instanceof TooLongFrameException) {
            String causeMsg = cause.getMessage();
            io.netty.handler.codec.http.HttpVersion version = obj instanceof HttpRequest ? ((HttpRequest)obj).protocolVersion() : (this.requestInProgress != null ? (this.requestInProgress.version() == HttpVersion.HTTP_1_0 ? io.netty.handler.codec.http.HttpVersion.HTTP_1_0 : io.netty.handler.codec.http.HttpVersion.HTTP_1_1) : io.netty.handler.codec.http.HttpVersion.HTTP_1_1);
            HttpResponseStatus status = causeMsg.startsWith("An HTTP line is larger than") ? HttpResponseStatus.REQUEST_URI_TOO_LONG : HttpResponseStatus.BAD_REQUEST;
            DefaultFullHttpResponse resp = new DefaultFullHttpResponse(version, status);
            ChannelPromise fut = this.chctx.newPromise();
            this.writeToChannel((Object)resp, fut);
            fut.addListener(res -> this.fail(result.cause()));
        } else {
            this.fail(result.cause());
        }
    }
}

