/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import io.netty.util.concurrent.FutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.AssembledFullHttpRequest;
import io.vertx.core.http.impl.AssembledHttpRequest;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.WebSocketHandshakeInboundHandler;
import io.vertx.core.http.impl.WebSocketImpl;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.net.impl.clientconnection.ConnectionListener;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.streams.impl.InboundBuffer;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

class Http1xClientConnection
extends Http1xConnectionBase<WebSocketImpl>
implements HttpClientConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xClientConnection.class);
    private static final Handler<Object> INVALID_MSG_HANDLER = msg -> {
        throw new IllegalStateException("Invalid object " + msg);
    };
    private final ConnectionListener<HttpClientConnection> listener;
    private final HttpClientImpl client;
    private final HttpClientOptions options;
    private final boolean ssl;
    private final SocketAddress server;
    private final Object endpointMetric;
    private final HttpClientMetrics metrics;
    private final HttpVersion version;
    private Deque<Stream> requests = new ArrayDeque<Stream>();
    private Deque<Stream> responses = new ArrayDeque<Stream>();
    private boolean closed;
    private boolean shutdown;
    private long shutdownTimerID = -1L;
    private Handler<Object> invalidMessageHandler = INVALID_MSG_HANDLER;
    private boolean close;
    private Promise<NetSocket> netSocketPromise;
    private int keepAliveTimeout;
    private long expirationTimestamp;
    private int seq = 1;
    private long bytesRead;

    Http1xClientConnection(ConnectionListener<HttpClientConnection> listener, HttpVersion version, HttpClientImpl client, Object endpointMetric, ChannelHandlerContext channel, boolean ssl, SocketAddress server, ContextInternal context, HttpClientMetrics metrics) {
        super(client.getVertx(), channel, context);
        this.listener = listener;
        this.client = client;
        this.options = client.getOptions();
        this.ssl = ssl;
        this.server = server;
        this.metrics = metrics;
        this.version = version;
        this.endpointMetric = endpointMetric;
        this.keepAliveTimeout = this.options.getKeepAliveTimeout();
    }

    Object endpointMetric() {
        return this.endpointMetric;
    }

    ConnectionListener<HttpClientConnection> listener() {
        return this.listener;
    }

    private HttpRequest createRequest(HttpMethod method, String uri, MultiMap headerMap, String authority, boolean chunked) {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpUtils.toNettyHttpVersion(this.version), method.toNetty(), uri, false);
        io.netty.handler.codec.http.HttpHeaders headers = request.headers();
        if (headerMap != null) {
            for (Map.Entry header : headerMap) {
                headers.add((String)header.getKey(), header.getValue());
            }
        }
        if (!headers.contains(HttpHeaders.HOST)) {
            request.headers().set(HttpHeaders.HOST, (Object)authority);
        } else {
            headers.remove(HttpHeaders.TRANSFER_ENCODING);
        }
        if (chunked) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)request, (boolean)true);
        }
        if (this.options.isTryUseCompression() && request.headers().get(HttpHeaders.ACCEPT_ENCODING) == null) {
            request.headers().set(HttpHeaders.ACCEPT_ENCODING, (Object)HttpHeaders.DEFLATE_GZIP);
        }
        if (!this.options.isKeepAlive() && this.options.getProtocolVersion() == HttpVersion.HTTP_1_1) {
            request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.CLOSE);
        } else if (this.options.isKeepAlive() && this.options.getProtocolVersion() == HttpVersion.HTTP_1_0) {
            request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.KEEP_ALIVE);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginRequest(Stream stream, HttpRequest request, Handler<AsyncResult<Void>> handler) {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            VertxTracer tracer;
            this.responses.add(stream);
            this.netSocketPromise = ((StreamImpl)stream).netSocketPromise;
            if (this.metrics != null) {
                stream.metric = this.metrics.requestBegin(this.endpointMetric, this.metric(), this.localAddress(), this.remoteAddress(), stream.request);
            }
            if ((tracer = this.context.tracer()) != null) {
                ArrayList<AbstractMap.SimpleEntry<String, String>> tags = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
                tags.add(new AbstractMap.SimpleEntry<String, String>("http.url", stream.request.absoluteURI()));
                tags.add(new AbstractMap.SimpleEntry<String, String>("http.method", stream.request.method().name()));
                BiConsumer<String, String> headers = (key, val) -> request.headers().add(key, val);
                stream.trace = tracer.sendRequest(stream.context, stream.request, stream.request.method.name(), headers, HttpUtils.CLIENT_REQUEST_TAG_EXTRACTOR);
            }
        }
        this.writeToChannel((Object)request, handler == null ? null : this.context.promise(handler));
        if (request instanceof LastHttpContent) {
            this.endRequest(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRequest(Stream s) {
        boolean recycle;
        Stream next;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            this.requests.pop();
            next = this.requests.peek();
            recycle = s.responseEnded;
            if (this.metrics != null) {
                this.metrics.requestEnd(s.metric);
            }
        }
        this.reportBytesWritten(this.bytesWritten);
        this.bytesWritten = 0L;
        if (next != null) {
            next.promise.complete((HttpClientStream)((Object)next));
        }
        if (recycle) {
            this.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRequest(Stream stream) {
        boolean close;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.responses.remove(stream)) {
                close = true;
            } else if (this.requests.remove(stream)) {
                close = false;
            } else {
                return;
            }
        }
        if (close) {
            this.close();
        } else {
            this.recycle();
        }
    }

    private void drainResponse(Stream n) {
        if (!n.responseEnded) {
            this.doResume();
        }
    }

    private void checkLifecycle() {
        if (this.close) {
            this.close();
        } else {
            this.recycle();
        }
    }

    private Throwable validateMessage(Object msg) {
        if (msg instanceof HttpObject) {
            io.netty.handler.codec.http.HttpVersion version;
            HttpObject obj = (HttpObject)msg;
            DecoderResult result = obj.decoderResult();
            if (result.isFailure()) {
                return result.cause();
            }
            if (obj instanceof HttpResponse && (version = ((HttpResponse)obj).protocolVersion()) != io.netty.handler.codec.http.HttpVersion.HTTP_1_0 && version != io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                return new IllegalStateException("Unsupported HTTP version: " + version);
            }
        }
        return null;
    }

    @Override
    public void handleMessage(Object msg) {
        Throwable error = this.validateMessage(msg);
        if (error != null) {
            this.fail(error);
        } else if (msg instanceof HttpObject) {
            HttpObject obj = (HttpObject)msg;
            this.handleHttpMessage(obj);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWsFrame((WebSocketFrame)msg);
        } else {
            this.invalidMessageHandler.handle(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttpMessage(HttpObject obj) {
        Stream stream;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            stream = this.responses.peekFirst();
            if (stream == null) {
                return;
            }
        }
        if (obj instanceof HttpResponse) {
            this.handleResponseBegin(stream, (HttpResponse)obj);
        } else if (obj instanceof HttpContent) {
            HttpContent chunk = (HttpContent)obj;
            if (chunk.content().isReadable()) {
                Buffer buff = Buffer.buffer(VertxHandler.safeBuffer(chunk.content(), this.chctx.alloc()));
                this.handleResponseChunk(stream, buff);
            }
            if (chunk instanceof LastHttpContent) {
                this.handleResponseEnd(stream, (LastHttpContent)chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseBegin(final Stream stream, HttpResponse resp) {
        if (resp.status().code() == 100) {
            stream.context.schedule(null, v -> stream.handleContinue());
        } else {
            HttpClientResponseImpl response;
            HttpClientRequestImpl request;
            Http1xClientConnection http1xClientConnection = this;
            synchronized (http1xClientConnection) {
                request = stream.request;
                HttpVersion version = resp.protocolVersion() == io.netty.handler.codec.http.HttpVersion.HTTP_1_0 ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
                response = new HttpClientResponseImpl(request, version, (HttpClientStream)((Object)stream), resp.status().code(), resp.status().reasonPhrase(), new HeadersAdaptor(resp.headers()));
                stream.response = response;
                if (this.metrics != null) {
                    this.metrics.responseBegin(stream.metric, response);
                }
                if (resp.status().code() != 100 && request.method() != HttpMethod.CONNECT) {
                    int timeout;
                    String responseConnectionHeader = resp.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
                    io.netty.handler.codec.http.HttpVersion protocolVersion = resp.protocolVersion();
                    String requestConnectionHeader = request.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
                    if (HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)responseConnectionHeader) || HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)requestConnectionHeader)) {
                        this.close = true;
                    } else if (protocolVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_0 && !HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase((CharSequence)responseConnectionHeader)) {
                        this.close = true;
                    }
                    String keepAliveHeader = resp.headers().get((CharSequence)HttpHeaderNames.KEEP_ALIVE);
                    if (keepAliveHeader != null && (timeout = HttpUtils.parseKeepAliveHeaderTimeout(keepAliveHeader)) != -1) {
                        this.keepAliveTimeout = timeout;
                    }
                }
            }
            stream.context.schedule(response, stream::handleBegin);
            Promise<NetSocket> promise = this.netSocketPromise;
            this.netSocketPromise = null;
            if (promise != null) {
                if (request.method == HttpMethod.CONNECT && response.statusCode() == 200 || request.method == HttpMethod.GET && request.headers().contains("connection", "Upgrade", false) && response.statusCode() == 101) {
                    this.listener.onEvict();
                    ChannelPipeline pipeline = this.chctx.pipeline();
                    ChannelHandler inflater = pipeline.get(HttpContentDecompressor.class);
                    if (inflater != null) {
                        pipeline.remove(inflater);
                    }
                    ArrayDeque pending = new ArrayDeque();
                    this.invalidMessageHandler = pending::add;
                    pipeline.remove("codec");
                    NetSocketImpl socket = new NetSocketImpl(this.vertx, this.chctx, this.context, this.client.getSslHelper(), this.metrics){

                        @Override
                        protected void handleClosed() {
                            if (Http1xClientConnection.this.metrics != null) {
                                Http1xClientConnection.this.metrics.responseEnd(stream.metric, response);
                            }
                            super.handleClosed();
                        }
                    };
                    socket.metric(this.metric());
                    pipeline.replace("handler", "handler", VertxHandler.create(ctx -> socket));
                    promise.complete(socket);
                    for (Object msg : pending) {
                        pipeline.fireChannelRead(msg);
                    }
                } else {
                    promise.fail("Server responded with " + response.statusCode() + " code instead of 200");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseChunk(Stream stream, Buffer buff) {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            this.bytesRead += (long)buff.length();
        }
        stream.context.schedule(buff, stream::handleChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseEnd(Stream stream, LastHttpContent trailer) {
        boolean check;
        long bytesRead;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (stream.response == null) {
                return;
            }
            this.responses.pop();
            bytesRead = this.bytesRead;
            this.bytesRead = 0L;
            this.close |= !this.options.isKeepAlive();
            stream.responseEnded = true;
            check = this.requests.peek() != stream;
        }
        VertxTracer tracer = this.context.tracer();
        if (tracer != null) {
            tracer.receiveResponse(stream.context, stream.response, stream.trace, null, HttpUtils.CLIENT_RESPONSE_TAG_EXTRACTOR);
        }
        if (this.metrics != null) {
            this.metrics.responseEnd(stream.metric, stream.response);
        }
        stream.context.schedule(trailer, stream::handleEnd);
        this.doResume();
        this.reportBytesRead(bytesRead);
        if (check) {
            this.checkLifecycle();
        }
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.metrics;
    }

    synchronized void toWebSocket(String requestURI, MultiMap headers, WebsocketVersion vers, List<String> subProtocols, int maxWebSocketFrameSize, Promise<WebSocket> promise) {
        try {
            DefaultHttpHeaders nettyHeaders;
            URI wsuri = new URI(requestURI);
            if (!wsuri.isAbsolute()) {
                wsuri = new URI((this.ssl ? "https:" : "http:") + "//" + this.server.host() + ":" + this.server.port() + requestURI);
            }
            WebSocketVersion version = WebSocketVersion.valueOf((String)((Enum)(vers == null ? WebSocketVersion.V13 : vers)).toString());
            if (headers != null) {
                nettyHeaders = new DefaultHttpHeaders();
                for (Map.Entry entry : headers) {
                    nettyHeaders.add((String)entry.getKey(), entry.getValue());
                }
            } else {
                nettyHeaders = null;
            }
            ChannelPipeline p = this.chctx.channel().pipeline();
            ArrayList<WebSocketClientExtensionHandshaker> extensionHandshakers = this.initializeWebSocketExtensionHandshakers(this.client.getOptions());
            if (!extensionHandshakers.isEmpty()) {
                p.addBefore("handler", "webSocketsExtensionsHandler", (ChannelHandler)new WebSocketClientExtensionHandler(extensionHandshakers.toArray(new WebSocketClientExtensionHandshaker[extensionHandshakers.size()])));
            }
            String subp = null;
            if (subProtocols != null) {
                subp = String.join((CharSequence)",", subProtocols);
            }
            WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)wsuri, (WebSocketVersion)version, (String)subp, (!extensionHandshakers.isEmpty() ? 1 : 0) != 0, (io.netty.handler.codec.http.HttpHeaders)nettyHeaders, (int)maxWebSocketFrameSize, (!this.options.isSendUnmaskedFrames() ? 1 : 0) != 0, (boolean)false, (long)-1L);
            WebSocketHandshakeInboundHandler handshakeInboundHandler = new WebSocketHandshakeInboundHandler(handshaker, ar -> {
                AsyncResult<Function<HeadersAdaptor, WebSocket>> wsRes = ar.map(v -> {
                    WebSocketImpl w = new WebSocketImpl(this.getContext(), this, version != WebSocketVersion.V00, this.options.getMaxWebSocketFrameSize(), this.options.getMaxWebSocketMessageSize());
                    w.subProtocol(handshaker.actualSubprotocol());
                    return w;
                });
                if (ar.failed()) {
                    this.close();
                } else {
                    this.webSocket = (WebSocketImpl)((Object)wsRes.result());
                    ((WebSocketImpl)this.webSocket).registerHandler(this.vertx.eventBus());
                }
                log.debug("WebSocket handshake complete");
                if (this.metrics != null) {
                    ((WebSocketImpl)this.webSocket).setMetric(this.metrics.connected(this.endpointMetric, this.metric(), (WebSocket)((Object)this.webSocket)));
                }
                this.getContext().dispatch(wsRes, res -> {
                    if (res.succeeded()) {
                        ((WebSocketImpl)this.webSocket).headers((MultiMap)ar.result());
                    }
                    promise.handle((AsyncResult<WebSocket>)res);
                    if (res.succeeded()) {
                        ((WebSocketImpl)this.webSocket).headers(null);
                    }
                });
            });
            p.addBefore("handler", "handshakeCompleter", (ChannelHandler)handshakeInboundHandler);
            handshaker.handshake(this.chctx.channel());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    ArrayList<WebSocketClientExtensionHandshaker> initializeWebSocketExtensionHandshakers(HttpClientOptions options) {
        ArrayList<WebSocketClientExtensionHandshaker> extensionHandshakers = new ArrayList<WebSocketClientExtensionHandshaker>();
        if (options.getTryWebSocketDeflateFrameCompression()) {
            extensionHandshakers.add((WebSocketClientExtensionHandshaker)new DeflateFrameClientExtensionHandshaker(options.getWebSocketCompressionLevel(), false));
        }
        if (options.getTryUsePerMessageWebSocketCompression()) {
            extensionHandshakers.add((WebSocketClientExtensionHandshaker)new PerMessageDeflateClientExtensionHandshaker(options.getWebSocketCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, options.getWebSocketCompressionAllowClientNoContext(), options.getWebSocketCompressionRequestServerNoContext()));
        }
        return extensionHandshakers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInterestedOpsChanged() {
        Handler<Boolean> handler;
        ContextInternal context;
        boolean writable = !this.isNotWritable();
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            Stream current = this.requests.peek();
            if (current != null) {
                context = current.context;
                handler = current::handleWritabilityChanged;
            } else if (this.webSocket != null) {
                context = ((WebSocketImpl)this.webSocket).context;
                handler = ((WebSocketImpl)this.webSocket)::handleWritabilityChanged;
            } else {
                return;
            }
        }
        context.schedule(writable, handler);
    }

    private Iterable<Stream> pendingStreams() {
        LinkedHashSet<Stream> list = new LinkedHashSet<Stream>();
        list.addAll(this.requests);
        list.addAll(this.responses);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClosed() {
        Iterable<Stream> streams;
        WebSocketImpl ws;
        super.handleClosed();
        long timerID = this.shutdownTimerID;
        if (timerID != -1L) {
            this.shutdownTimerID = -1L;
            this.vertx.cancelTimer(timerID);
        }
        this.closed = true;
        if (this.metrics != null) {
            this.metrics.endpointDisconnected(this.endpointMetric, this.metric());
        }
        VertxTracer tracer = this.context.tracer();
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            ws = (WebSocketImpl)this.webSocket;
            streams = this.pendingStreams();
        }
        if (this.netSocketPromise != null) {
            this.netSocketPromise.fail(ConnectionBase.CLOSED_EXCEPTION);
        }
        if (ws != null) {
            ws.handleClosed();
        }
        for (Stream stream : streams) {
            if (this.metrics != null) {
                this.metrics.requestReset(stream.metric);
            }
            if (tracer != null) {
                tracer.receiveResponse(stream.context, null, stream.trace, ConnectionBase.CLOSED_EXCEPTION, TagExtractor.empty());
            }
            stream.context.schedule(null, v -> stream.handleClosed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleIdle() {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.webSocket == null && this.responses.isEmpty() && this.requests.isEmpty()) {
                return;
            }
        }
        super.handleIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleException(Throwable e) {
        Iterable<Stream> streams;
        WebSocketImpl ws;
        super.handleException(e);
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            ws = (WebSocketImpl)this.webSocket;
            streams = this.pendingStreams();
        }
        if (ws != null) {
            ws.handleException(e);
        }
        for (Stream stream : streams) {
            stream.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStream(ContextInternal context, HttpClientRequestImpl req, Promise<NetSocket> netSocketPromise, Handler<AsyncResult<HttpClientStream>> handler) {
        EventLoop eventLoop = context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            StreamImpl stream;
            Http1xClientConnection http1xClientConnection = this;
            synchronized (http1xClientConnection) {
                if (this.closed) {
                    stream = null;
                } else {
                    stream = new StreamImpl(context, this, req, netSocketPromise, this.seq++);
                    this.requests.add(stream);
                    if (this.requests.size() == 1) {
                        stream.promise.complete(stream);
                    }
                }
            }
            if (stream != null) {
                stream.promise.future().onComplete(handler);
            } else {
                handler.handle(Future.failedFuture(CLOSED_EXCEPTION));
            }
        } else {
            eventLoop.execute(() -> this.createStream(context, req, netSocketPromise, handler));
        }
    }

    @Override
    public boolean isValid() {
        return this.expirationTimestamp == 0L || System.currentTimeMillis() <= this.expirationTimestamp;
    }

    private void recycle() {
        if (this.shutdown) {
            if (this.requests.isEmpty() && this.responses.isEmpty()) {
                this.close();
            }
        } else {
            this.expirationTimestamp = this.keepAliveTimeout == 0 ? 0L : System.currentTimeMillis() + (long)(this.keepAliveTimeout * 1000);
            this.listener.onRecycle();
        }
    }

    @Override
    public void shutdown(long timeout, Handler<AsyncResult<Void>> handler) {
        this.shutdown(timeout, this.vertx.promise(handler));
    }

    @Override
    public Future<Void> shutdown(long timeoutMs) {
        PromiseInternal<Void> promise = this.vertx.promise();
        this.shutdown(timeoutMs, promise);
        return promise.future();
    }

    private synchronized void shutdownNow() {
        this.shutdownTimerID = -1L;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(long timeoutMs, PromiseInternal<Void> promise) {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.shutdown) {
                promise.fail("Already shutdown");
                return;
            }
            if (this.netSocketPromise != null) {
                promise.fail("Connection upgraded to NetSocket");
                return;
            }
            this.shutdown = true;
            this.closeFuture().onComplete(promise);
        }
        this.listener.onEvict();
        http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (!this.closed) {
                if (timeoutMs > 0L) {
                    this.shutdownTimerID = this.context.setTimer(timeoutMs, id -> this.shutdownNow());
                } else {
                    this.close = true;
                }
            }
        }
        this.checkLifecycle();
    }

    private static class StreamImpl
    extends Stream
    implements HttpClientStream {
        private final Http1xClientConnection conn;
        private final InboundBuffer<Object> queue;
        private final Promise<NetSocket> netSocketPromise;
        private boolean reset;
        private boolean writable;

        StreamImpl(ContextInternal context, Http1xClientConnection conn, HttpClientRequestImpl request, Promise<NetSocket> netSocketPromise, int id) {
            super(context, id, request);
            this.writable = !conn.isNotWritable();
            this.conn = conn;
            this.netSocketPromise = netSocketPromise;
            this.queue = new InboundBuffer(context, 5L).drainHandler(v -> {
                EventLoop eventLoop = conn.context.nettyEventLoop();
                if (eventLoop.inEventLoop()) {
                    this.drained();
                } else {
                    eventLoop.execute(this::drained);
                }
            }).exceptionHandler(context::reportException);
        }

        private void drained() {
            this.conn.drainResponse(this);
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public Object metric() {
            return super.metric();
        }

        @Override
        public HttpVersion version() {
            return this.conn.version;
        }

        @Override
        public HttpClientConnection connection() {
            return this.conn;
        }

        @Override
        public ContextInternal getContext() {
            return this.context;
        }

        @Override
        public void writeHead(HttpMethod method, String uri, MultiMap headers, String authority, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, Handler<AsyncResult<Void>> handler) {
            HttpRequest request = this.conn.createRequest(method, uri, headers, authority, chunked);
            if (end) {
                request = buf != null ? new AssembledFullHttpRequest(request, buf) : new AssembledFullHttpRequest(request);
            } else if (buf != null) {
                request = new AssembledHttpRequest(request, buf);
            }
            this.writeHead(request, handler == null ? null : this.context.promise(handler));
        }

        private void writeHead(HttpRequest request, Handler<AsyncResult<Void>> handler) {
            EventLoop eventLoop = this.conn.context.nettyEventLoop();
            if (eventLoop.inEventLoop()) {
                this.conn.beginRequest(this, request, handler);
            } else {
                eventLoop.execute(() -> this.writeHead(request, handler));
            }
        }

        @Override
        public void writeBuffer(ByteBuf buff, boolean end, Handler<AsyncResult<Void>> handler) {
            if (buff == null && !end) {
                return;
            }
            Object msg = end ? (buff != null && buff.isReadable() ? new DefaultLastHttpContent(buff, false) : LastHttpContent.EMPTY_LAST_CONTENT) : new DefaultHttpContent(buff);
            this.writeBuffer((HttpContent)msg, handler == null ? null : this.context.promise(handler));
        }

        private void writeBuffer(HttpContent content, FutureListener<Void> listener) {
            EventLoop eventLoop = this.conn.context.nettyEventLoop();
            if (eventLoop.inEventLoop()) {
                this.conn.writeToChannel((Object)content, listener);
                if (content instanceof LastHttpContent) {
                    this.conn.endRequest(this);
                }
            } else {
                eventLoop.execute(() -> this.writeBuffer(content, listener));
            }
        }

        @Override
        public void writeFrame(int type, int flags, ByteBuf payload) {
            throw new IllegalStateException("Cannot write an HTTP/2 frame over an HTTP/1.x connection");
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
            this.conn.doSetWriteQueueMaxSize(size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isNotWritable() {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                return !this.writable;
            }
        }

        @Override
        public void doPause() {
            this.queue.pause();
        }

        @Override
        public void doFetch(long amount) {
            this.queue.fetch(amount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset(Throwable cause) {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.reset) {
                    return;
                }
                this.reset = true;
            }
            this.handleException(cause);
            EventLoop eventLoop = this.conn.context.nettyEventLoop();
            if (eventLoop.inEventLoop()) {
                this.reset();
            } else {
                eventLoop.execute(this::reset);
            }
        }

        private void reset() {
            this.conn.resetRequest(this);
        }

        @Override
        public StreamPriority priority() {
            return null;
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handleWritabilityChanged(boolean writable) {
            boolean drain;
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                drain = !this.writable && writable;
                this.writable = writable;
            }
            if (drain) {
                this.request.handleDrained();
            }
        }

        @Override
        void handleContinue() {
            this.request.handleContinue();
        }

        @Override
        void handleBegin(HttpClientResponseImpl response) {
            this.queue.handler(item -> {
                if (item instanceof MultiMap) {
                    response.handleEnd((MultiMap)item);
                } else {
                    response.handleChunk((Buffer)item);
                }
            });
            this.request.handleResponse(response);
        }

        @Override
        void handleChunk(Buffer buff) {
            if (!this.queue.write(buff)) {
                this.conn.doPause();
            }
        }

        @Override
        void handleEnd(LastHttpContent trailer) {
            this.queue.write((Object)new HeadersAdaptor(trailer.trailingHeaders()));
        }

        @Override
        void handleException(Throwable cause) {
            this.request.handleException(cause);
        }

        @Override
        void handleClosed() {
            this.handleException(ConnectionBase.CLOSED_EXCEPTION);
        }
    }

    private static abstract class Stream {
        protected final Promise<HttpClientStream> promise;
        protected final ContextInternal context;
        protected final int id;
        protected final HttpClientRequestImpl request;
        private Object trace;
        private Object metric;
        private HttpClientResponseImpl response;
        private boolean responseEnded;

        Stream(ContextInternal context, int id, HttpClientRequestImpl request) {
            this.context = context;
            this.id = id;
            this.request = request;
            this.promise = context.promise();
        }

        Object metric() {
            return this.metric;
        }

        abstract void handleContinue();

        abstract void handleBegin(HttpClientResponseImpl var1);

        abstract void handleChunk(Buffer var1);

        abstract void handleEnd(LastHttpContent var1);

        abstract void handleWritabilityChanged(boolean var1);

        abstract void handleException(Throwable var1);

        abstract void handleClosed();
    }
}

