/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.tracing;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.tracing.TracingOptionsConverter;

@DataObject(generateConverter=true, publicConverter=false)
public class TracingOptions {
    public static final boolean DEFAULT_TRACING_ENABLED = false;
    private boolean enabled;
    private JsonObject json;
    private VertxTracerFactory factory;

    public TracingOptions() {
        this.enabled = false;
    }

    public TracingOptions(TracingOptions other) {
        this.enabled = other.isEnabled();
        this.factory = other.factory;
    }

    public TracingOptions(JsonObject json) {
        this();
        TracingOptionsConverter.fromJson(json, this);
        this.json = json.copy();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TracingOptions setEnabled(boolean enable) {
        this.enabled = enable;
        return this;
    }

    public VertxTracerFactory getFactory() {
        return this.factory;
    }

    public TracingOptions setFactory(VertxTracerFactory factory) {
        this.factory = factory;
        return this;
    }

    public TracingOptions copy() {
        return new TracingOptions(this);
    }

    public JsonObject toJson() {
        return this.json != null ? this.json.copy() : new JsonObject();
    }

    public String toString() {
        return "TracingOptions{enabled=" + this.enabled + ", json=" + this.json + '}';
    }
}

